(*
% File     : SYN054+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 24
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 24 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   12 (   0 equality)
%            Maximal formula depth :    4 (   4 average)
%            Number of connectives :    9 (   2 ~  ;   2  |;   2  &)
%                                         (   0 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   2 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_s_ : Universe -> Prop.
Variable big_r_ : Universe -> Prop.
Variable big_q_ : Universe -> Prop.
Variable big_p_ : Universe -> Prop.


Variable pel24_1_1 : ~((exists X : Universe, (big_s_ X /\ big_q_ X))).
Variable pel24_2_2 : (forall X : Universe, (big_p_ X -> (big_q_ X \/ big_r_ X))).
Variable pel24_3_3 : (~((exists X : Universe, big_p_ X)) -> (exists Y : Universe, big_q_ Y)).
Variable pel24_4_4 : (forall X : Universe, ((big_q_ X \/ big_r_ X) -> big_s_ X)).

Set Firstorder Depth 10.

Theorem pel24_5 : (exists X : Universe, (big_p_ X /\ big_r_ X)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
