(*
% File     : SYJ206+1.002 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Equivalences
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 2
% English  : (..(( p(1) <=> p(2)) <=> p(3)) <=> .. <=> p(N))  <=>
%            (p(N) <=> ( p(N-1) <=> (.. (p(2) <=> p(1)) ) ))
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
% Source   : [Dyc97]
% Names    : equiv_p2 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : this formula is different to the equivalences formulated
%            in Pelletier 71 [Pel86], TPTP SYN007+1
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable a2_ : Prop.
Variable a1_ : Prop.



Set Firstorder Depth 10.

Theorem con_1 : ((a1_ <-> a2_) <-> (a2_ <-> a1_)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
