(*
% File     : SYJ205+1.006 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Formulae of Korn & Kreitz
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 6
% English  : ((A & B(N) & C1(N)) => f) & ((C2(N) & B(N) & A) => f) with
%            A = (a(0) => f), B(N) = (b(N) => b(0) => a(N)),
%            C1(N) = (&&_{i=1..n} ((b(i-1) => a(i)) => a(i-1))),
%            C2(N) = (&&_{i=n..1} ((b(i-1) => a(i)) => a(i-1)))
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
%          : [KK97]  D. Korn & C. Kreitz, A constructively adequate
%                    refutation system for intuitionistic logic,
%                    position paper at Tableaux'97, available at
%                    http://www.cs.uni-potsdam.de/ti/kreitz/PDF/
% Source   : [Dyc97]
% Names    : kk_p6 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable f_ : Prop.
Variable b6_ : Prop.
Variable b5_ : Prop.
Variable b4_ : Prop.
Variable b3_ : Prop.
Variable b2_ : Prop.
Variable b1_ : Prop.
Variable b0_ : Prop.
Variable a6_ : Prop.
Variable a5_ : Prop.
Variable a4_ : Prop.
Variable a3_ : Prop.
Variable a2_ : Prop.
Variable a1_ : Prop.
Variable a0_ : Prop.



Set Firstorder Depth 10.

Theorem con_1 : ((((a0_ -> f_) /\ (((b6_ -> b0_) -> a6_) /\ (((b0_ -> a1_) -> a0_) /\ (((b1_ -> a2_) -> a1_) /\ (((b2_ -> a3_) -> a2_) /\ (((b3_ -> a4_) -> a3_) /\ (((b4_ -> a5_) -> a4_) /\ ((b5_ -> a6_) -> a5_)))))))) -> f_) /\ ((((b5_ -> a6_) -> a5_) /\ (((b4_ -> a5_) -> a4_) /\ (((b3_ -> a4_) -> a3_) /\ (((b2_ -> a3_) -> a2_) /\ (((b1_ -> a2_) -> a1_) /\ (((b0_ -> a1_) -> a0_) /\ (((b6_ -> b0_) -> a6_) /\ (a0_ -> f_)))))))) -> f_)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
