(*
% File     : SYJ203+1.002 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Formulae requiring many contractions
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 2
% English  : (((&&_{i=1..N} p(i)) | (||_{i=1..N} (p(i)=>f)))=>f)=>f
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
%          : [Fr88]  T. Franzen, Algorithmic Aspects of intuitionistic
%                    propositional logic, SICS Research Report R87010B,
%                    1988.
%          : [Fr89]  T. Franzen, Algorithmic Aspects of intuitionistic
%                    propositional logic II, SICS Research Report
%                    R-89/89006, 1989.
% Source   : [Dyc97]
% Names    : con_p2 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : proof in LJ needs n contractions [Dyc97]
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p2_ : Prop.
Variable p1_ : Prop.
Variable f_ : Prop.


Variable axiom1_1 : (((p1_ /\ p2_) \/ ((p1_ -> f_) \/ (p2_ -> f_))) -> f_).

Set Firstorder Depth 10.

Theorem con_2 : f_.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
