(*
% File     : SYJ202+1.002 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Cook pigeon-hole problem
% Version  : Especial.
%            Problem formulation : Prop. Non-Clausal. Intuit. Valid  Size 2
% English  : Suppose there are N holes and N+1 pigeons to put in the
%            holes. Every pigeon is in a hole and no hole contains more
%            than one pigeon. Prove that this is impossible. The size is
%            the number of pigeons.
%            LHS(N) => RHS(N) with 
%            LHS(N) = &&_{p=1..N+1} (||_{h=1,..N} o(p,h) )
%            RHS(N) = ||_{h=1..N, p1=1..{N+1}, p2={p1+1}..{N+1}} s(p1,p2,h)
%            with s(p1,p2,h) = o(p1,h) & o(p2,h)
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
%          : [CR79]  Cook & Reckhow (1979), The Relative Efficiency of
%                    Propositional Proof Systems, Journal of Symbolic
%                    Logic 44, pp.36-50.
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing
%                    Automatic Theorem Provers, Journal of Automated
%                    Reasoning 2(2), pp.191-216.
% Source   : [Dyc97]
% Names    : ph_p2 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable o32_ : Prop.
Variable o31_ : Prop.
Variable o22_ : Prop.
Variable o21_ : Prop.
Variable o12_ : Prop.
Variable o11_ : Prop.


Variable axiom1_1 : (o11_ \/ o12_).
Variable axiom2_2 : (o21_ \/ o22_).
Variable axiom3_3 : (o31_ \/ o32_).

Set Firstorder Depth 10.

Theorem con_4 : ((o11_ /\ o21_) \/ ((o11_ /\ o31_) \/ ((o21_ /\ o31_) \/ ((o12_ /\ o22_) \/ ((o12_ /\ o32_) \/ (o22_ /\ o32_)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
