(*
% File     : SYJ116+1.002 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : 
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 2
% English  : 
% Refs     : [SN00]  S. Schmitt & A. Nogin: test module jprover_tests.ml,
%                    test formulas for JProver in MetaPRL, at
%                    http://cvs.metaprl.org:12000/cvsweb/metaprl/theories/
%                         itt/jprover_tests.ml
%            [ES98] U. Egly & S. Schmitt. Intuitionistic proof 
%                   transformations and their application to constructive 
%                   program synthesis, In J. Calmet & J. Plaza (Eds.), 
%                   Proceedings of the 4th International Conference on 
%                   Artificial Intelligence and Symbolic Computation, 
%                   LNAI 1476, p. 132-144, Springer Verlag, 1998
% Source   : [SN00]
% Names    : fo_n2 : JProver test formulae (2000)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : cause exponential proof length in EVERY LJ proof wrt. the 
%            proof length of a given LJmc proof in first-order 
%            intuitionistic logic 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable b1_ : Prop.
Variable b_ : Prop.
Variable a2_ : Universe -> Prop.
Variable a1_ : Universe -> Prop.
Variable a_ : Universe -> Prop.


Variable axiom1_1 : (forall W : Universe, a2_ W).
Variable axiom2_2 : (forall X : Universe, ((b_ \/ a_ X) \/ b_)).
Variable axiom3_3 : ~((b_ /\ (forall Y : Universe, a1_ Y))).
Variable axiom4_4 : ~((b1_ /\ (forall Y : Universe, a2_ Y))).
Variable axiom5_5 : (forall X : Universe, ((b1_ \/ a1_ X) \/ b1_)).

Set Firstorder Depth 10.

Theorem con_6 : (forall Z : Universe, a_ Z).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
