(*
% File     : SYJ106+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : 
% Version  : Especial.
% English  : 
% Refs     : [SN00]  S. Schmitt & A. Nogin: test module jprover_tests.ml,
%                    test formulas for JProver in MetaPRL, at
%                    http://cvs.metaprl.org:12000/cvsweb/metaprl/theories/
%                         itt/jprover_tests.ml
%            [OK96] J. Otten und C. Kreitz. A uniform proof procedure
%                   for classical and non-classical logics. In KI-96: 
%                   Advances in Artificial Intelligence, LNAI 1137, 
%                   p. 307-319, Springer Verlag, 1996.
% Source   : [SN00]
% Names    : jens_prop : JProver test formulae (2000)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable t_ : Prop.
Variable s_ : Prop.
Variable r_ : Prop.
Variable q_ : Prop.
Variable p_ : Prop.


Variable axiom1_1 : s_.
Variable axiom2_2 : (~((t_ -> r_)) -> p_).

Set Firstorder Depth 10.

Theorem con_3 : (~(((p_ -> q_) /\ (t_ -> r_))) -> (~(~(p_)) /\ (s_ /\ s_))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
