(*
% File     : SYJ034+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : formula being Problematic for Ft-Algorithm
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft7a : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable q_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable p_ : Universe -> Prop.

Variable a2_ : Universe.
Variable a1_ : Universe.

Variable axiom1_1 : q_ a1_ a2_ a1_ a2_.

Set Firstorder Depth 10.

Theorem con_2 : (exists X1 : Universe, (exists X2 : Universe, (exists Y1 : Universe, (exists Y2 : Universe, (((p_ X1 /\ p_ X2) <-> (p_ Y1 /\ p_ Y2)) /\ q_ X1 X2 Y1 Y2))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
