(*
% File     : SYJ025+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Simple
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft6.7 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : ...just some short formulae, written sown more or less at
%            random... [SFH92]
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable s_ : Universe -> Prop.
Variable r_ : Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.


Variable axiom1_1 : (exists X : Universe, p_ X).
Variable axiom2_2 : (forall X : Universe, (forall Y : Universe, ((p_ Y /\ q_ X) -> ~(r_ X)))).

Set Firstorder Depth 10.

Theorem con_3 : (forall X : Universe, ((q_ X /\ r_ X) -> s_ X)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
