(*
% File     : SYJ016+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Unify
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft5.1 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.

Variable f_ : Universe -> Universe -> Universe.


Set Firstorder Depth 10.

Theorem con_1 : (forall X0 : Universe, (exists X1 : Universe, (exists X2 : Universe, (exists X3 : Universe, (exists X4 : Universe, (exists X5 : Universe, (p_ X1 X2 X3 X4 X5 <-> p_ (f_ X0 X0) (f_ X1 X1) (f_ X2 X2) (f_ X3 X3) (f_ X4 X4)))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
