(*
% File     : SWV129+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_inuse_0002
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the inuse-safety verification for
%            the thruster program. inuse-safety ensures that each sensor
%            reading passed as an input to the Kalman filter algorithm is
%            actually used during the computation of the output estimate.
% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_inuse_0002 [Fis04]
% Status   : CounterSatisfiable
% Rating   : 1.00 v3.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  119 (  83 unit)
%            Number of atoms       : 1523 (1006 equality)
%            Maximal formula depth :   52 (   4 average)
%            Number of connectives : 1425 (  21 ~  ;  23  |;1231  &)
%                                         (   5 <=>; 145 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   1 propositional; 0-2 arity)
%            Number of functors    :   40 (  22 constant; 0-4 arity)
%            Number of variables   :  262 (   2 singleton; 262 !;   0 ?)
%            Maximal term depth    :   17 (   3 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable true_ : Prop.
Variable lt_ : Universe -> Universe -> Prop.
Variable EqCongruence_lt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> lt_ x1 x2 -> lt_ y1 y2 .
Variable leq_ : Universe -> Universe -> Prop.
Variable EqCongruence_leq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> leq_ x1 x2 -> leq_ y1 y2 .
Variable gt_ : Universe -> Universe -> Prop.
Variable EqCongruence_gt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> gt_ x1 x2 -> gt_ y1 y2 .
Variable geq_ : Universe -> Universe -> Prop.
Variable EqCongruence_geq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> geq_ x1 x2 -> geq_ y1 y2 .

Variable z_defuse_ : Universe.
Variable xinit_mean_defuse_ : Universe.
Variable xinit_defuse_ : Universe.
Variable use_ : Universe.
Variable uniform_int_rnd_ : Universe -> Universe -> Universe.
Variable EqCongruence_uniform_int_rnd : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> uniform_int_rnd_ x1 x2 = uniform_int_rnd_ y1 y2 .
Variable trans_ : Universe -> Universe.
Variable EqCongruence_trans : forall x1 y1 : Universe, x1 = y1 -> trans_ x1 = trans_ y1 .
Variable tptp_update3_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_tptp_update3 : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> tptp_update3_ x1 x2 x3 x4 = tptp_update3_ y1 y2 y3 y4 .
Variable tptp_update2_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_tptp_update2 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> tptp_update2_ x1 x2 x3 = tptp_update2_ y1 y2 y3 .
Variable tptp_msub_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_msub : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_msub_ x1 x2 = tptp_msub_ y1 y2 .
Variable tptp_mmul_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_mmul : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_mmul_ x1 x2 = tptp_mmul_ y1 y2 .
Variable tptp_minus_1_ : Universe.
Variable tptp_madd_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_madd : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_madd_ x1 x2 = tptp_madd_ y1 y2 .
Variable tptp_const_array2_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_tptp_const_array2 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> tptp_const_array2_ x1 x2 x3 = tptp_const_array2_ y1 y2 y3 .
Variable tptp_const_array1_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_const_array1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_const_array1_ x1 x2 = tptp_const_array1_ y1 y2 .
Variable sum_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_sum : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> sum_ x1 x2 x3 = sum_ y1 y2 y3 .
Variable succ_ : Universe -> Universe.
Variable EqCongruence_succ : forall x1 y1 : Universe, x1 = y1 -> succ_ x1 = succ_ y1 .
Variable sigma_ : Universe.
Variable pv5_ : Universe.
Variable pv34_ : Universe.
Variable pv33_ : Universe.
Variable pv25_ : Universe.
Variable pv23_ : Universe.
Variable pred_ : Universe -> Universe.
Variable EqCongruence_pred : forall x1 y1 : Universe, x1 = y1 -> pred_ x1 = pred_ y1 .
Variable plus_ : Universe -> Universe -> Universe.
Variable EqCongruence_plus : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> plus_ x1 x2 = plus_ y1 y2 .
Variable n7_ : Universe.
Variable n6_ : Universe.
Variable n588_ : Universe.
Variable n5_ : Universe.
Variable n4_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1000_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable minus_ : Universe -> Universe -> Universe.
Variable EqCongruence_minus : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> minus_ x1 x2 = minus_ y1 y2 .
Variable inv_ : Universe -> Universe.
Variable EqCongruence_inv : forall x1 y1 : Universe, x1 = y1 -> inv_ x1 = inv_ y1 .
Variable dim_ : Universe -> Universe -> Universe.
Variable EqCongruence_dim : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> dim_ x1 x2 = dim_ y1 y2 .
Variable def_ : Universe.
Variable a_select3_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_a_select3 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> a_select3_ x1 x2 x3 = a_select3_ y1 y2 y3 .
Variable a_select2_ : Universe -> Universe -> Universe.
Variable EqCongruence_a_select2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> a_select2_ x1 x2 = a_select2_ y1 y2 .

Variable totality_1 : (forall X Y : Universe, (gt_ X Y \/ (gt_ Y X \/ X = Y))).
Variable transitivity_gt_2 : (forall X Y Z : Universe, ((gt_ X Y /\ gt_ Y Z) -> gt_ X Z)).
Variable irreflexivity_gt_3 : (forall X : Universe, ~(gt_ X X)).
Variable reflexivity_leq_4 : (forall X : Universe, leq_ X X).
Variable transitivity_leq_5 : (forall X Y Z : Universe, ((leq_ X Y /\ leq_ Y Z) -> leq_ X Z)).
Variable lt_gt_6 : (forall X Y : Universe, (lt_ X Y <-> gt_ Y X)).
Variable leq_geq_7 : (forall X Y : Universe, (geq_ X Y <-> leq_ Y X)).
Variable leq_gt1_8 : (forall X Y : Universe, (gt_ Y X -> leq_ X Y)).
Variable leq_gt2_9 : (forall X Y : Universe, ((leq_ X Y /\ X <> Y) -> gt_ Y X)).
Variable leq_gt_pred_10 : (forall X Y : Universe, (leq_ X (pred_ Y) <-> gt_ Y X)).
Variable gt_succ_11 : (forall X : Universe, gt_ (succ_ X) X).
Variable leq_succ_12 : (forall X Y : Universe, (leq_ X Y -> leq_ X (succ_ Y))).
Variable leq_succ_gt_equiv_13 : (forall X Y : Universe, (leq_ X Y <-> gt_ (succ_ Y) X)).
Variable uniform_int_rand_ranges_hi_14 : (forall X C : Universe, (leq_ n0_ X -> leq_ (uniform_int_rnd_ C X) X)).
Variable uniform_int_rand_ranges_lo_15 : (forall X C : Universe, (leq_ n0_ X -> leq_ n0_ (uniform_int_rnd_ C X))).
Variable const_array1_select_16 : (forall I L U Val : Universe, ((leq_ L I /\ leq_ I U) -> (a_select2_ (tptp_const_array1_ (dim_ L U) Val) I) = Val)).
Variable const_array2_select_17 : (forall I L1 U1 J L2 U2 Val : Universe, ((leq_ L1 I /\ (leq_ I U1 /\ (leq_ L2 J /\ leq_ J U2))) -> (a_select3_ (tptp_const_array2_ (dim_ L1 U1) (dim_ L2 U2) Val) I J) = Val)).
Variable matrix_symm_aba1_18 : (forall I0 J0 A B N : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (a_select3_ B I0 J0) = (a_select3_ B J0 I0))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_aba2_19 : (forall I0 J0 I J A B N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ (a_select3_ B I J) = (a_select3_ B J I))))))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_add_20 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_madd_ A B) I J) = (a_select3_ (tptp_madd_ A B) J I))).
Variable matrix_symm_sub_21 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_msub_ A B) I J) = (a_select3_ (tptp_msub_ A B) J I))).
Variable matrix_symm_trans_22 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (trans_ A) I J) = (a_select3_ (trans_ A) J I))).
Variable matrix_symm_inv_23 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (inv_ A) I J) = (a_select3_ (inv_ A) J I))).
Variable matrix_symm_joseph_update_24 : (forall I0 J0 I J A B C D E F N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ ((a_select3_ D I J) = (a_select3_ D J I) /\ ((a_select3_ A I0 J0) = (a_select3_ A J0 I0) /\ (a_select3_ F I0 J0) = (a_select3_ F J0 I0))))))))))) -> (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) I0 J0) = (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) J0 I0))).
Variable sum_plus_base_25 : (forall Body : Universe, (sum_ n0_ tptp_minus_1_ Body) = n0_).
Variable succ_tptp_minus_1_26 : (succ_ tptp_minus_1_) = n0_.
Variable succ_plus_1_r_27 : (forall X : Universe, (plus_ X n1_) = (succ_ X)).
Variable succ_plus_1_l_28 : (forall X : Universe, (plus_ n1_ X) = (succ_ X)).
Variable succ_plus_2_r_29 : (forall X : Universe, (plus_ X n2_) = (succ_ (succ_ X))).
Variable succ_plus_2_l_30 : (forall X : Universe, (plus_ n2_ X) = (succ_ (succ_ X))).
Variable succ_plus_3_r_31 : (forall X : Universe, (plus_ X n3_) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_3_l_32 : (forall X : Universe, (plus_ n3_ X) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_4_r_33 : (forall X : Universe, (plus_ X n4_) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_4_l_34 : (forall X : Universe, (plus_ n4_ X) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_5_r_35 : (forall X : Universe, (plus_ X n5_) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable succ_plus_5_l_36 : (forall X : Universe, (plus_ n5_ X) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable pred_minus_1_37 : (forall X : Universe, (minus_ X n1_) = (pred_ X)).
Variable pred_succ_38 : (forall X : Universe, (pred_ (succ_ X)) = X).
Variable succ_pred_39 : (forall X : Universe, (succ_ (pred_ X)) = X).
Variable leq_succ_succ_40 : (forall X Y : Universe, (leq_ (succ_ X) (succ_ Y) <-> leq_ X Y)).
Variable leq_succ_gt_41 : (forall X Y : Universe, (leq_ (succ_ X) Y -> gt_ Y X)).
Variable leq_minus_42 : (forall X Y : Universe, (leq_ (minus_ X Y) X -> leq_ n0_ Y)).
Variable sel3_update_1_43 : (forall X U V VAL : Universe, (a_select3_ (tptp_update3_ X U V VAL) U V) = VAL).
Variable sel3_update_2_44 : (forall I J U V X VAL VAL2 : Universe, ((I <> U /\ (J = V /\ (a_select3_ X U V) = VAL)) -> (a_select3_ (tptp_update3_ X I J VAL2) U V) = VAL)).
Variable sel3_update_3_45 : (forall I J U V X VAL : Universe, (((forall I0 J0 : Universe, ((leq_ n0_ I0 /\ (leq_ n0_ J0 /\ (leq_ I0 U /\ leq_ J0 V))) -> (a_select3_ X I0 J0) = VAL)) /\ (leq_ n0_ I /\ (leq_ I U /\ (leq_ n0_ J /\ leq_ J V)))) -> (a_select3_ (tptp_update3_ X U V VAL) I J) = VAL)).
Variable sel2_update_1_46 : (forall X U VAL : Universe, (a_select2_ (tptp_update2_ X U VAL) U) = VAL).
Variable sel2_update_2_47 : (forall I U X VAL VAL2 : Universe, ((I <> U /\ (a_select2_ X U) = VAL) -> (a_select2_ (tptp_update2_ X I VAL2) U) = VAL)).
Variable sel2_update_3_48 : (forall I U X VAL : Universe, (((forall I0 : Universe, ((leq_ n0_ I0 /\ leq_ I0 U) -> (a_select2_ X I0) = VAL)) /\ (leq_ n0_ I /\ leq_ I U)) -> (a_select2_ (tptp_update2_ X U VAL) I) = VAL)).
Variable ttrue_49 : true_.
Variable defuse_50 : def_ <> use_.
Variable gt_1000_588_51 : gt_ n1000_ n588_.
Variable gt_588_4_52 : gt_ n588_ n4_.
Variable gt_5_4_53 : gt_ n5_ n4_.
Variable gt_6_4_54 : gt_ n6_ n4_.
Variable gt_7_4_55 : gt_ n7_ n4_.
Variable gt_1000_4_56 : gt_ n1000_ n4_.
Variable gt_588_5_57 : gt_ n588_ n5_.
Variable gt_6_5_58 : gt_ n6_ n5_.
Variable gt_7_5_59 : gt_ n7_ n5_.
Variable gt_1000_5_60 : gt_ n1000_ n5_.
Variable gt_588_6_61 : gt_ n588_ n6_.
Variable gt_7_6_62 : gt_ n7_ n6_.
Variable gt_1000_6_63 : gt_ n1000_ n6_.
Variable gt_588_7_64 : gt_ n588_ n7_.
Variable gt_1000_7_65 : gt_ n1000_ n7_.
Variable gt_588_tptp_minus_1_66 : gt_ n588_ tptp_minus_1_.
Variable gt_4_tptp_minus_1_67 : gt_ n4_ tptp_minus_1_.
Variable gt_5_tptp_minus_1_68 : gt_ n5_ tptp_minus_1_.
Variable gt_6_tptp_minus_1_69 : gt_ n6_ tptp_minus_1_.
Variable gt_7_tptp_minus_1_70 : gt_ n7_ tptp_minus_1_.
Variable gt_0_tptp_minus_1_71 : gt_ n0_ tptp_minus_1_.
Variable gt_1_tptp_minus_1_72 : gt_ n1_ tptp_minus_1_.
Variable gt_2_tptp_minus_1_73 : gt_ n2_ tptp_minus_1_.
Variable gt_1000_tptp_minus_1_74 : gt_ n1000_ tptp_minus_1_.
Variable gt_3_tptp_minus_1_75 : gt_ n3_ tptp_minus_1_.
Variable gt_588_0_76 : gt_ n588_ n0_.
Variable gt_4_0_77 : gt_ n4_ n0_.
Variable gt_5_0_78 : gt_ n5_ n0_.
Variable gt_6_0_79 : gt_ n6_ n0_.
Variable gt_7_0_80 : gt_ n7_ n0_.
Variable gt_1_0_81 : gt_ n1_ n0_.
Variable gt_2_0_82 : gt_ n2_ n0_.
Variable gt_1000_0_83 : gt_ n1000_ n0_.
Variable gt_3_0_84 : gt_ n3_ n0_.
Variable gt_588_1_85 : gt_ n588_ n1_.
Variable gt_4_1_86 : gt_ n4_ n1_.
Variable gt_5_1_87 : gt_ n5_ n1_.
Variable gt_6_1_88 : gt_ n6_ n1_.
Variable gt_7_1_89 : gt_ n7_ n1_.
Variable gt_2_1_90 : gt_ n2_ n1_.
Variable gt_1000_1_91 : gt_ n1000_ n1_.
Variable gt_3_1_92 : gt_ n3_ n1_.
Variable gt_588_2_93 : gt_ n588_ n2_.
Variable gt_4_2_94 : gt_ n4_ n2_.
Variable gt_5_2_95 : gt_ n5_ n2_.
Variable gt_6_2_96 : gt_ n6_ n2_.
Variable gt_7_2_97 : gt_ n7_ n2_.
Variable gt_1000_2_98 : gt_ n1000_ n2_.
Variable gt_3_2_99 : gt_ n3_ n2_.
Variable gt_588_3_100 : gt_ n588_ n3_.
Variable gt_4_3_101 : gt_ n4_ n3_.
Variable gt_5_3_102 : gt_ n5_ n3_.
Variable gt_6_3_103 : gt_ n6_ n3_.
Variable gt_7_3_104 : gt_ n7_ n3_.
Variable gt_1000_3_105 : gt_ n1000_ n3_.
Variable finite_domain_4_106 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n4_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ X = n4_)))))).
Variable finite_domain_5_107 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n5_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ X = n5_))))))).
Variable finite_domain_6_108 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n6_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ (X = n5_ \/ X = n6_)))))))).
Variable finite_domain_0_109 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n0_) -> X = n0_)).
Variable finite_domain_1_110 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n1_) -> (X = n0_ \/ X = n1_))).
Variable finite_domain_2_111 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n2_) -> (X = n0_ \/ (X = n1_ \/ X = n2_)))).
Variable finite_domain_3_112 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n3_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ X = n3_))))).
Variable successor_4_113 : (succ_ (succ_ (succ_ (succ_ n0_)))) = n4_.
Variable successor_5_114 : (succ_ (succ_ (succ_ (succ_ (succ_ n0_))))) = n5_.
Variable successor_6_115 : (succ_ (succ_ (succ_ (succ_ (succ_ (succ_ n0_)))))) = n6_.
Variable successor_1_116 : (succ_ n0_) = n1_.
Variable successor_2_117 : (succ_ (succ_ n0_)) = n2_.
Variable successor_3_118 : (succ_ (succ_ (succ_ n0_))) = n3_.

Set Firstorder Depth 10.

Theorem thruster_inuse_0002_119 : ((geq_ (minus_ n4_ n1_) n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> (forall A : Universe, ((geq_ n7_ n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> (forall P4 : Universe, ((true_ -> (a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_defuse_ n0_ use_) n0_ use_) n0_ use_) n0_ use_) n0_) = use_) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_)))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (forall B C : Universe, ((leq_ n0_ B /\ (leq_ n0_ C /\ (leq_ B n3_ /\ leq_ C (minus_ n0_ n1_)))) -> ((a_select3_ z_defuse_ B C) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) B C) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) B C) = use_)))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv23_ /\ (leq_ pv5_ n588_ /\ (leq_ pv23_ (minus_ n6_ n1_) /\ ((forall D E : Universe, ((leq_ n0_ D /\ (leq_ n0_ E /\ (leq_ D n3_ /\ leq_ E pv5_))) -> ((a_select3_ z_defuse_ D E) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) D E) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) D E) = use_)))) /\ (forall F G : Universe, ((leq_ n0_ F /\ (leq_ n0_ G /\ (leq_ F n3_ /\ leq_ G (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ F G) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) F G) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) F G) = use_)))))))))))))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H I : Universe, ((leq_ n0_ H /\ (leq_ n0_ I /\ (leq_ H n3_ /\ leq_ I pv5_))) -> ((a_select3_ z_defuse_ H I) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) H I) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) H I) = use_)))) /\ (forall J K : Universe, ((leq_ n0_ J /\ (leq_ n0_ K /\ (leq_ J n3_ /\ leq_ K (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ J K) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) J K) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) J K) = use_))))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv33_ /\ (leq_ n0_ pv34_ /\ (leq_ pv5_ n588_ /\ (leq_ pv33_ (minus_ n6_ n1_) /\ (leq_ pv34_ (minus_ n6_ n1_) /\ (forall L M : Universe, ((leq_ n0_ L /\ (leq_ n0_ M /\ (leq_ L n3_ /\ leq_ M (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ L M) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) L M) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) L M) = use_))))))))))))))))))))))))))))) -> ((pv33_ <> pv34_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv33_ /\ (leq_ pv5_ n588_ /\ (leq_ pv33_ (minus_ n6_ n1_) /\ (forall N O : Universe, ((leq_ n0_ N /\ (leq_ n0_ O /\ (leq_ N n3_ /\ leq_ O (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ N O) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) N O) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) N O) = use_)))))))))))))))))))))))))))) /\ (pv33_ = pv34_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv33_ /\ (leq_ pv5_ n588_ /\ (leq_ pv33_ (minus_ n6_ n1_) /\ (forall P Q : Universe, ((leq_ n0_ P /\ (leq_ n0_ Q /\ (leq_ P n3_ /\ leq_ Q (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ P Q) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) P Q) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) P Q) = use_)))))))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv33_ /\ (leq_ pv5_ n588_ /\ (leq_ pv33_ (minus_ n6_ n1_) /\ (forall R S : Universe, ((leq_ n0_ R /\ (leq_ n0_ S /\ (leq_ R n3_ /\ leq_ S (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ R S) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) R S) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) R S) = use_))))))))))))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv33_ /\ (leq_ pv5_ n588_ /\ (leq_ pv33_ (minus_ n6_ n1_) /\ (forall T U : Universe, ((leq_ n0_ T /\ (leq_ n0_ U /\ (leq_ T n3_ /\ leq_ U (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ T U) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) T U) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) T U) = use_)))))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv33_ /\ (leq_ pv5_ n588_ /\ (leq_ pv33_ (minus_ n6_ n1_) /\ (forall V W : Universe, ((leq_ n0_ V /\ (leq_ n0_ W /\ (leq_ V n3_ /\ leq_ W (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ V W) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) V W) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) V W) = use_))))))))))))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ (forall X Y : Universe, ((leq_ n0_ X /\ (leq_ n0_ Y /\ (leq_ X n3_ /\ leq_ Y (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ X Y) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) X Y) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) X Y) = use_)))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall Z A1 : Universe, ((leq_ n0_ Z /\ (leq_ n0_ A1 /\ (leq_ Z n3_ /\ leq_ A1 pv5_))) -> ((a_select3_ z_defuse_ Z A1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) Z A1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) Z A1) = use_)))) /\ (forall B1 C1 : Universe, ((leq_ n0_ B1 /\ (leq_ n0_ C1 /\ (leq_ B1 n3_ /\ leq_ C1 (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ B1 C1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) B1 C1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) B1 C1) = use_)))))))))))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall D1 E1 : Universe, ((leq_ n0_ D1 /\ (leq_ n0_ E1 /\ (leq_ D1 n3_ /\ leq_ E1 pv5_))) -> ((a_select3_ z_defuse_ D1 E1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) D1 E1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) D1 E1) = use_)))) /\ (forall F1 G1 : Universe, ((leq_ n0_ F1 /\ (leq_ n0_ G1 /\ (leq_ F1 n3_ /\ leq_ G1 (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ F1 G1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) F1 G1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) F1 G1) = use_))))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H1 I1 : Universe, ((leq_ n0_ H1 /\ (leq_ n0_ I1 /\ (leq_ H1 n3_ /\ leq_ I1 pv5_))) -> ((a_select3_ z_defuse_ H1 I1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) H1 I1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) H1 I1) = use_)))) /\ (forall J1 K1 : Universe, ((leq_ n0_ J1 /\ (leq_ n0_ K1 /\ (leq_ J1 n3_ /\ leq_ K1 (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ J1 K1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) J1 K1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) J1 K1) = use_)))))))))))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (forall L1 M1 : Universe, ((leq_ n0_ L1 /\ (leq_ n0_ M1 /\ (leq_ L1 n3_ /\ leq_ M1 (minus_ (plus_ n1_ pv5_) n1_)))) -> ((a_select3_ z_defuse_ L1 M1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) L1 M1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) L1 M1) = use_)))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ (forall N1 O1 : Universe, ((leq_ n0_ N1 /\ (leq_ n0_ O1 /\ (leq_ N1 n3_ /\ leq_ O1 (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ N1 O1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) N1 O1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) N1 O1) = use_))))))))))))))))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ (forall P1 Q1 : Universe, ((leq_ n0_ P1 /\ (leq_ n0_ Q1 /\ (leq_ P1 n3_ /\ leq_ Q1 (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ P1 Q1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) P1 Q1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) P1 Q1) = use_)))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ (forall R1 S1 : Universe, ((leq_ n0_ R1 /\ (leq_ n0_ S1 /\ (leq_ R1 n3_ /\ leq_ S1 (minus_ pv5_ n1_)))) -> ((a_select3_ z_defuse_ R1 S1) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) R1 S1) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) R1 S1) = use_))))))))))))))))))))))))) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall T1 U1 : Universe, ((leq_ n0_ T1 /\ (leq_ n0_ U1 /\ (leq_ T1 n3_ /\ leq_ U1 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) T1 U1) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) T1 U1) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) T1 U1) = use_)))) /\ (forall V1 W1 : Universe, ((leq_ n0_ V1 /\ (leq_ n0_ W1 /\ (leq_ V1 n3_ /\ leq_ W1 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) V1 W1) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) V1 W1) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) V1 W1) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall X1 Y1 : Universe, ((leq_ n0_ X1 /\ (leq_ n0_ Y1 /\ (leq_ X1 n3_ /\ leq_ Y1 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) X1 Y1) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) X1 Y1) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) X1 Y1) = use_)))) /\ (forall Z1 A2 : Universe, ((leq_ n0_ Z1 /\ (leq_ n0_ A2 /\ (leq_ Z1 n3_ /\ leq_ A2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) Z1 A2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) Z1 A2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) Z1 A2) = use_))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B2 C2 : Universe, ((leq_ n0_ B2 /\ (leq_ n0_ C2 /\ (leq_ B2 n3_ /\ leq_ C2 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) B2 C2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) B2 C2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) B2 C2) = use_)))) /\ (forall D2 E2 : Universe, ((leq_ n0_ D2 /\ (leq_ n0_ E2 /\ (leq_ D2 n3_ /\ leq_ E2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) D2 E2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) D2 E2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) D2 E2) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall F2 G2 : Universe, ((leq_ n0_ F2 /\ (leq_ n0_ G2 /\ (leq_ F2 n3_ /\ leq_ G2 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) F2 G2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) F2 G2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) F2 G2) = use_)))) /\ (forall H2 I2 : Universe, ((leq_ n0_ H2 /\ (leq_ n0_ I2 /\ (leq_ H2 n3_ /\ leq_ I2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) H2 I2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) H2 I2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) H2 I2) = use_))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall J2 K2 : Universe, ((leq_ n0_ J2 /\ (leq_ n0_ K2 /\ (leq_ J2 n3_ /\ leq_ K2 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) J2 K2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) J2 K2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) J2 K2) = use_)))) /\ (forall L2 M2 : Universe, ((leq_ n0_ L2 /\ (leq_ n0_ M2 /\ (leq_ L2 n3_ /\ leq_ M2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) L2 M2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) L2 M2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) L2 M2) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall N2 O2 : Universe, ((leq_ n0_ N2 /\ (leq_ n0_ O2 /\ (leq_ N2 n3_ /\ leq_ O2 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) N2 O2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) N2 O2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) N2 O2) = use_)))) /\ (forall P2 Q2 : Universe, ((leq_ n0_ P2 /\ (leq_ n0_ Q2 /\ (leq_ P2 n3_ /\ leq_ Q2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) P2 Q2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) P2 Q2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) P2 Q2) = use_))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall R2 S2 : Universe, ((leq_ n0_ R2 /\ (leq_ n0_ S2 /\ (leq_ R2 n3_ /\ leq_ S2 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) R2 S2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) R2 S2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) R2 S2) = use_)))) /\ (forall T2 U2 : Universe, ((leq_ n0_ T2 /\ (leq_ n0_ U2 /\ (leq_ T2 n3_ /\ leq_ U2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) T2 U2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) T2 U2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) T2 U2) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall V2 W2 : Universe, ((leq_ n0_ V2 /\ (leq_ n0_ W2 /\ (leq_ V2 n3_ /\ leq_ W2 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) V2 W2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) V2 W2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) V2 W2) = use_)))) /\ (forall X2 Y2 : Universe, ((leq_ n0_ X2 /\ (leq_ n0_ Y2 /\ (leq_ X2 n3_ /\ leq_ Y2 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) X2 Y2) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) X2 Y2) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) X2 Y2) = use_))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall Z2 A3 : Universe, ((leq_ n0_ Z2 /\ (leq_ n0_ A3 /\ (leq_ Z2 n3_ /\ leq_ A3 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) Z2 A3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) Z2 A3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) Z2 A3) = use_)))) /\ (forall B3 C3 : Universe, ((leq_ n0_ B3 /\ (leq_ n0_ C3 /\ (leq_ B3 n3_ /\ leq_ C3 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) B3 C3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) B3 C3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) B3 C3) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall D3 E3 : Universe, ((leq_ n0_ D3 /\ (leq_ n0_ E3 /\ (leq_ D3 n3_ /\ leq_ E3 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) D3 E3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) D3 E3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) D3 E3) = use_)))) /\ (forall F3 G3 : Universe, ((leq_ n0_ F3 /\ (leq_ n0_ G3 /\ (leq_ F3 n3_ /\ leq_ G3 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) F3 G3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) F3 G3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) F3 G3) = use_))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H3 I3 : Universe, ((leq_ n0_ H3 /\ (leq_ n0_ I3 /\ (leq_ H3 n3_ /\ leq_ I3 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) H3 I3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) H3 I3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) H3 I3) = use_)))) /\ (forall J3 K3 : Universe, ((leq_ n0_ J3 /\ (leq_ n0_ K3 /\ (leq_ J3 n3_ /\ leq_ K3 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) J3 K3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) J3 K3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) J3 K3) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall L3 M3 : Universe, ((leq_ n0_ L3 /\ (leq_ n0_ M3 /\ (leq_ L3 n3_ /\ leq_ M3 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) L3 M3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) L3 M3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) L3 M3) = use_)))) /\ (forall N3 O3 : Universe, ((leq_ n0_ N3 /\ (leq_ n0_ O3 /\ (leq_ N3 n3_ /\ leq_ O3 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) N3 O3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) N3 O3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) N3 O3) = use_))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall P3 Q3 : Universe, ((leq_ n0_ P3 /\ (leq_ n0_ Q3 /\ (leq_ P3 n3_ /\ leq_ Q3 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) P3 Q3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) P3 Q3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) P3 Q3) = use_)))) /\ (forall R3 S3 : Universe, ((leq_ n0_ R3 /\ (leq_ n0_ S3 /\ (leq_ R3 n3_ /\ leq_ S3 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) R3 S3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) R3 S3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) R3 S3) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall T3 U3 : Universe, ((leq_ n0_ T3 /\ (leq_ n0_ U3 /\ (leq_ T3 n3_ /\ leq_ U3 pv5_))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) T3 U3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) T3 U3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) T3 U3) = use_)))) /\ (forall V3 W3 : Universe, ((leq_ n0_ V3 /\ (leq_ n0_ W3 /\ (leq_ V3 n3_ /\ leq_ W3 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) V3 W3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) V3 W3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) V3 W3) = use_))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall X3 Y3 : Universe, ((leq_ n0_ X3 /\ (leq_ n0_ Y3 /\ (leq_ X3 n3_ /\ leq_ Y3 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) X3 Y3) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) X3 Y3) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) X3 Y3) = use_)))) /\ (forall Z3 A4 : Universe, ((leq_ n0_ Z3 /\ (leq_ n0_ A4 /\ (leq_ Z3 n3_ /\ leq_ A4 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) Z3 A4) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) Z3 A4) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) Z3 A4) = use_))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n7_ n0_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B4 C4 : Universe, ((leq_ n0_ B4 /\ (leq_ n0_ C4 /\ (leq_ B4 n3_ /\ leq_ C4 pv5_))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) B4 C4) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) B4 C4) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) B4 C4) = use_)))) /\ (forall D4 E4 : Universe, ((leq_ n0_ D4 /\ (leq_ n0_ E4 /\ (leq_ D4 n3_ /\ leq_ E4 (minus_ pv5_ n1_)))) -> ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ z_defuse_ n0_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) D4 E4) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n2_ pv5_ use_) n1_ pv5_ use_) n0_ pv5_ use_) D4 E4) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ pv5_ use_) n1_ pv5_ use_) n3_ pv5_ use_) n1_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) n2_ pv5_ use_) n3_ pv5_ use_) n5_ pv5_ use_) D4 E4) = use_))))))))))))))))))))))))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ (forall F4 G4 : Universe, ((leq_ n0_ F4 /\ (leq_ n0_ G4 /\ (leq_ F4 n3_ /\ leq_ G4 (minus_ (plus_ n1_ n588_) n1_)))) -> ((a_select3_ z_defuse_ F4 G4) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) F4 G4) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) F4 G4) = use_))))))))))))))))))))))) -> (def_ = use_ /\ ((forall H4 I4 : Universe, ((leq_ n0_ H4 /\ (leq_ n0_ I4 /\ (leq_ H4 (minus_ n4_ n1_) /\ leq_ I4 (minus_ n1000_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) H4 I4) = use_)) /\ ((forall J4 K4 : Universe, ((leq_ n0_ J4 /\ (leq_ n0_ K4 /\ (leq_ J4 n7_ /\ leq_ K4 (minus_ n1000_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) J4 K4) = use_)) /\ ((forall L4 : Universe, ((leq_ n0_ L4 /\ leq_ L4 (minus_ n6_ n1_)) -> (a_select2_ xinit_defuse_ L4) = use_)) /\ ((forall M4 : Universe, ((leq_ n0_ M4 /\ leq_ M4 (minus_ n6_ n1_)) -> (a_select2_ xinit_mean_defuse_ M4) = use_)) /\ (forall N4 O4 : Universe, ((leq_ n0_ N4 /\ (leq_ n0_ O4 /\ (leq_ N4 (minus_ n4_ n1_) /\ leq_ O4 (minus_ n1000_ n1_)))) -> (a_select3_ z_defuse_ N4 O4) = use_)))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_)))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_ use_) n1_ n0_ use_) n2_ n0_ use_) n3_ n0_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_ use_) n1_ n0_ use_) n2_ n0_ use_) n3_ n0_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_ use_) n1_ n0_ use_) n2_ n0_ use_) n3_ n0_ use_) n2_ n0_) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_ use_) n1_ n0_ use_) n2_ n0_ use_) n3_ n0_ use_) n3_ n0_) = use_))))))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_)))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n6_ n0_) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_ use_) n2_ n0_ use_) n7_ n0_) = use_))))))))) /\ ((((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_)))))))))))) -> ((a_select2_ xinit_defuse_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n6_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n7_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) def_) n3_ n0_) = use_ /\ ((a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_mean_defuse_ n0_ use_) n1_ use_) n2_ use_) n3_ use_) n4_ use_) n5_ use_) n0_) = use_ /\ ((a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_mean_defuse_ n0_ use_) n1_ use_) n2_ use_) n3_ use_) n4_ use_) n5_ use_) n1_) = use_ /\ ((a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_mean_defuse_ n0_ use_) n1_ use_) n2_ use_) n3_ use_) n4_ use_) n5_ use_) n2_) = use_ /\ ((a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_mean_defuse_ n0_ use_) n1_ use_) n2_ use_) n3_ use_) n4_ use_) n5_ use_) n3_) = use_ /\ ((a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_mean_defuse_ n0_ use_) n1_ use_) n2_ use_) n3_ use_) n4_ use_) n5_ use_) n4_) = use_ /\ (a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_mean_defuse_ n0_ use_) n1_ use_) n2_ use_) n3_ use_) n4_ use_) n5_ use_) n5_) = use_))))))))))))))))))) /\ (((leq_ n0_ pv25_ /\ leq_ pv25_ (minus_ n6_ n1_)) -> (leq_ n0_ (a_select2_ sigma_ pv25_) -> true_)) /\ (((a_select2_ xinit_defuse_ n0_) = use_ -> ((a_select2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ (tptp_update2_ xinit_defuse_ n0_ use_) n0_ use_) n0_ use_) n0_ use_) n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n0_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n2_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n3_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n4_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n5_ n0_) = use_ /\ ((a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n6_ n0_) = use_ /\ (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) def_) n1_ n0_ use_) n3_ n0_ use_) n1_ n0_ use_) n3_ n0_ use_) n7_ n0_) = use_))))))))) /\ (geq_ (minus_ n6_ n1_) n0_ -> (geq_ (minus_ n6_ n1_) n0_ -> ((geq_ (minus_ n4_ n1_) n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> true_))))))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
