(*
% File     : SWV097+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation quaternion_ds1_inuse_0009
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the inuse-safety verification for
%            the quaternion_ds1 program. inuse-safety ensures that each sensor
%            reading passed as an input to the Kalman filter algorithm is
%            actually used during the computation of the output estimate.
% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : quaternion_ds1_inuse_0009 [Fis04]
% Status   : Theorem
% Rating   : 0.82 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   90 (  55 unit)
%            Number of atoms       :  289 ( 139 equality)
%            Maximal formula depth :   38 (   4 average)
%            Number of connectives :  204 (   5 ~  ;  17  |; 142  &)
%                                         (   5 <=>;  35 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   1 propositional; 0-2 arity)
%            Number of functors    :   36 (  18 constant; 0-4 arity)
%            Number of variables   :  149 (   0 singleton; 149 !;   0 ?)
%            Maximal term depth    :    9 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable true_ : Prop.
Variable lt_ : Universe -> Universe -> Prop.
Variable EqCongruence_lt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> lt_ x1 x2 -> lt_ y1 y2 .
Variable leq_ : Universe -> Universe -> Prop.
Variable EqCongruence_leq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> leq_ x1 x2 -> leq_ y1 y2 .
Variable gt_ : Universe -> Universe -> Prop.
Variable EqCongruence_gt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> gt_ x1 x2 -> gt_ y1 y2 .
Variable geq_ : Universe -> Universe -> Prop.
Variable EqCongruence_geq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> geq_ x1 x2 -> geq_ y1 y2 .

Variable z_defuse_ : Universe.
Variable xinit_noise_defuse_ : Universe.
Variable xinit_mean_defuse_ : Universe.
Variable xinit_defuse_ : Universe.
Variable use_ : Universe.
Variable uniform_int_rnd_ : Universe -> Universe -> Universe.
Variable EqCongruence_uniform_int_rnd : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> uniform_int_rnd_ x1 x2 = uniform_int_rnd_ y1 y2 .
Variable u_defuse_ : Universe.
Variable trans_ : Universe -> Universe.
Variable EqCongruence_trans : forall x1 y1 : Universe, x1 = y1 -> trans_ x1 = trans_ y1 .
Variable tptp_update3_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_tptp_update3 : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> tptp_update3_ x1 x2 x3 x4 = tptp_update3_ y1 y2 y3 y4 .
Variable tptp_update2_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_tptp_update2 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> tptp_update2_ x1 x2 x3 = tptp_update2_ y1 y2 y3 .
Variable tptp_msub_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_msub : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_msub_ x1 x2 = tptp_msub_ y1 y2 .
Variable tptp_mmul_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_mmul : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_mmul_ x1 x2 = tptp_mmul_ y1 y2 .
Variable tptp_minus_1_ : Universe.
Variable tptp_madd_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_madd : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_madd_ x1 x2 = tptp_madd_ y1 y2 .
Variable tptp_const_array2_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_tptp_const_array2 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> tptp_const_array2_ x1 x2 x3 = tptp_const_array2_ y1 y2 y3 .
Variable tptp_const_array1_ : Universe -> Universe -> Universe.
Variable EqCongruence_tptp_const_array1 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> tptp_const_array1_ x1 x2 = tptp_const_array1_ y1 y2 .
Variable sum_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_sum : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> sum_ x1 x2 x3 = sum_ y1 y2 y3 .
Variable succ_ : Universe -> Universe.
Variable EqCongruence_succ : forall x1 y1 : Universe, x1 = y1 -> succ_ x1 = succ_ y1 .
Variable sigma_defuse_ : Universe.
Variable rho_defuse_ : Universe.
Variable pv5_ : Universe.
Variable pred_ : Universe -> Universe.
Variable EqCongruence_pred : forall x1 y1 : Universe, x1 = y1 -> pred_ x1 = pred_ y1 .
Variable plus_ : Universe -> Universe -> Universe.
Variable EqCongruence_plus : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> plus_ x1 x2 = plus_ y1 y2 .
Variable n999_ : Universe.
Variable n5_ : Universe.
Variable n4_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable minus_ : Universe -> Universe -> Universe.
Variable EqCongruence_minus : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> minus_ x1 x2 = minus_ y1 y2 .
Variable inv_ : Universe -> Universe.
Variable EqCongruence_inv : forall x1 y1 : Universe, x1 = y1 -> inv_ x1 = inv_ y1 .
Variable dim_ : Universe -> Universe -> Universe.
Variable EqCongruence_dim : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> dim_ x1 x2 = dim_ y1 y2 .
Variable def_ : Universe.
Variable a_select3_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_a_select3 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> a_select3_ x1 x2 x3 = a_select3_ y1 y2 y3 .
Variable a_select2_ : Universe -> Universe -> Universe.
Variable EqCongruence_a_select2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> a_select2_ x1 x2 = a_select2_ y1 y2 .

Variable totality_1 : (forall X Y : Universe, (gt_ X Y \/ (gt_ Y X \/ X = Y))).
Variable transitivity_gt_2 : (forall X Y Z : Universe, ((gt_ X Y /\ gt_ Y Z) -> gt_ X Z)).
Variable irreflexivity_gt_3 : (forall X : Universe, ~(gt_ X X)).
Variable reflexivity_leq_4 : (forall X : Universe, leq_ X X).
Variable transitivity_leq_5 : (forall X Y Z : Universe, ((leq_ X Y /\ leq_ Y Z) -> leq_ X Z)).
Variable lt_gt_6 : (forall X Y : Universe, (lt_ X Y <-> gt_ Y X)).
Variable leq_geq_7 : (forall X Y : Universe, (geq_ X Y <-> leq_ Y X)).
Variable leq_gt1_8 : (forall X Y : Universe, (gt_ Y X -> leq_ X Y)).
Variable leq_gt2_9 : (forall X Y : Universe, ((leq_ X Y /\ X <> Y) -> gt_ Y X)).
Variable leq_gt_pred_10 : (forall X Y : Universe, (leq_ X (pred_ Y) <-> gt_ Y X)).
Variable gt_succ_11 : (forall X : Universe, gt_ (succ_ X) X).
Variable leq_succ_12 : (forall X Y : Universe, (leq_ X Y -> leq_ X (succ_ Y))).
Variable leq_succ_gt_equiv_13 : (forall X Y : Universe, (leq_ X Y <-> gt_ (succ_ Y) X)).
Variable uniform_int_rand_ranges_hi_14 : (forall X C : Universe, (leq_ n0_ X -> leq_ (uniform_int_rnd_ C X) X)).
Variable uniform_int_rand_ranges_lo_15 : (forall X C : Universe, (leq_ n0_ X -> leq_ n0_ (uniform_int_rnd_ C X))).
Variable const_array1_select_16 : (forall I L U Val : Universe, ((leq_ L I /\ leq_ I U) -> (a_select2_ (tptp_const_array1_ (dim_ L U) Val) I) = Val)).
Variable const_array2_select_17 : (forall I L1 U1 J L2 U2 Val : Universe, ((leq_ L1 I /\ (leq_ I U1 /\ (leq_ L2 J /\ leq_ J U2))) -> (a_select3_ (tptp_const_array2_ (dim_ L1 U1) (dim_ L2 U2) Val) I J) = Val)).
Variable matrix_symm_aba1_18 : (forall I0 J0 A B N : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (a_select3_ B I0 J0) = (a_select3_ B J0 I0))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_aba2_19 : (forall I0 J0 I J A B N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ (a_select3_ B I J) = (a_select3_ B J I))))))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_add_20 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_madd_ A B) I J) = (a_select3_ (tptp_madd_ A B) J I))).
Variable matrix_symm_sub_21 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_msub_ A B) I J) = (a_select3_ (tptp_msub_ A B) J I))).
Variable matrix_symm_trans_22 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (trans_ A) I J) = (a_select3_ (trans_ A) J I))).
Variable matrix_symm_inv_23 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (inv_ A) I J) = (a_select3_ (inv_ A) J I))).
Variable matrix_symm_joseph_update_24 : (forall I0 J0 I J A B C D E F N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ ((a_select3_ D I J) = (a_select3_ D J I) /\ ((a_select3_ A I0 J0) = (a_select3_ A J0 I0) /\ (a_select3_ F I0 J0) = (a_select3_ F J0 I0))))))))))) -> (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) I0 J0) = (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) J0 I0))).
Variable sum_plus_base_25 : (forall Body : Universe, (sum_ n0_ tptp_minus_1_ Body) = n0_).
Variable succ_tptp_minus_1_26 : (succ_ tptp_minus_1_) = n0_.
Variable succ_plus_1_r_27 : (forall X : Universe, (plus_ X n1_) = (succ_ X)).
Variable succ_plus_1_l_28 : (forall X : Universe, (plus_ n1_ X) = (succ_ X)).
Variable succ_plus_2_r_29 : (forall X : Universe, (plus_ X n2_) = (succ_ (succ_ X))).
Variable succ_plus_2_l_30 : (forall X : Universe, (plus_ n2_ X) = (succ_ (succ_ X))).
Variable succ_plus_3_r_31 : (forall X : Universe, (plus_ X n3_) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_3_l_32 : (forall X : Universe, (plus_ n3_ X) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_4_r_33 : (forall X : Universe, (plus_ X n4_) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_4_l_34 : (forall X : Universe, (plus_ n4_ X) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_5_r_35 : (forall X : Universe, (plus_ X n5_) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable succ_plus_5_l_36 : (forall X : Universe, (plus_ n5_ X) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable pred_minus_1_37 : (forall X : Universe, (minus_ X n1_) = (pred_ X)).
Variable pred_succ_38 : (forall X : Universe, (pred_ (succ_ X)) = X).
Variable succ_pred_39 : (forall X : Universe, (succ_ (pred_ X)) = X).
Variable leq_succ_succ_40 : (forall X Y : Universe, (leq_ (succ_ X) (succ_ Y) <-> leq_ X Y)).
Variable leq_succ_gt_41 : (forall X Y : Universe, (leq_ (succ_ X) Y -> gt_ Y X)).
Variable leq_minus_42 : (forall X Y : Universe, (leq_ (minus_ X Y) X -> leq_ n0_ Y)).
Variable sel3_update_1_43 : (forall X U V VAL : Universe, (a_select3_ (tptp_update3_ X U V VAL) U V) = VAL).
Variable sel3_update_2_44 : (forall I J U V X VAL VAL2 : Universe, ((I <> U /\ (J = V /\ (a_select3_ X U V) = VAL)) -> (a_select3_ (tptp_update3_ X I J VAL2) U V) = VAL)).
Variable sel3_update_3_45 : (forall I J U V X VAL : Universe, (((forall I0 J0 : Universe, ((leq_ n0_ I0 /\ (leq_ n0_ J0 /\ (leq_ I0 U /\ leq_ J0 V))) -> (a_select3_ X I0 J0) = VAL)) /\ (leq_ n0_ I /\ (leq_ I U /\ (leq_ n0_ J /\ leq_ J V)))) -> (a_select3_ (tptp_update3_ X U V VAL) I J) = VAL)).
Variable sel2_update_1_46 : (forall X U VAL : Universe, (a_select2_ (tptp_update2_ X U VAL) U) = VAL).
Variable sel2_update_2_47 : (forall I U X VAL VAL2 : Universe, ((I <> U /\ (a_select2_ X U) = VAL) -> (a_select2_ (tptp_update2_ X I VAL2) U) = VAL)).
Variable sel2_update_3_48 : (forall I U X VAL : Universe, (((forall I0 : Universe, ((leq_ n0_ I0 /\ leq_ I0 U) -> (a_select2_ X I0) = VAL)) /\ (leq_ n0_ I /\ leq_ I U)) -> (a_select2_ (tptp_update2_ X U VAL) I) = VAL)).
Variable ttrue_49 : true_.
Variable defuse_50 : def_ <> use_.
Variable gt_5_4_51 : gt_ n5_ n4_.
Variable gt_999_4_52 : gt_ n999_ n4_.
Variable gt_999_5_53 : gt_ n999_ n5_.
Variable gt_4_tptp_minus_1_54 : gt_ n4_ tptp_minus_1_.
Variable gt_5_tptp_minus_1_55 : gt_ n5_ tptp_minus_1_.
Variable gt_999_tptp_minus_1_56 : gt_ n999_ tptp_minus_1_.
Variable gt_0_tptp_minus_1_57 : gt_ n0_ tptp_minus_1_.
Variable gt_1_tptp_minus_1_58 : gt_ n1_ tptp_minus_1_.
Variable gt_2_tptp_minus_1_59 : gt_ n2_ tptp_minus_1_.
Variable gt_3_tptp_minus_1_60 : gt_ n3_ tptp_minus_1_.
Variable gt_4_0_61 : gt_ n4_ n0_.
Variable gt_5_0_62 : gt_ n5_ n0_.
Variable gt_999_0_63 : gt_ n999_ n0_.
Variable gt_1_0_64 : gt_ n1_ n0_.
Variable gt_2_0_65 : gt_ n2_ n0_.
Variable gt_3_0_66 : gt_ n3_ n0_.
Variable gt_4_1_67 : gt_ n4_ n1_.
Variable gt_5_1_68 : gt_ n5_ n1_.
Variable gt_999_1_69 : gt_ n999_ n1_.
Variable gt_2_1_70 : gt_ n2_ n1_.
Variable gt_3_1_71 : gt_ n3_ n1_.
Variable gt_4_2_72 : gt_ n4_ n2_.
Variable gt_5_2_73 : gt_ n5_ n2_.
Variable gt_999_2_74 : gt_ n999_ n2_.
Variable gt_3_2_75 : gt_ n3_ n2_.
Variable gt_4_3_76 : gt_ n4_ n3_.
Variable gt_5_3_77 : gt_ n5_ n3_.
Variable gt_999_3_78 : gt_ n999_ n3_.
Variable finite_domain_4_79 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n4_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ X = n4_)))))).
Variable finite_domain_5_80 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n5_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ X = n5_))))))).
Variable finite_domain_0_81 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n0_) -> X = n0_)).
Variable finite_domain_1_82 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n1_) -> (X = n0_ \/ X = n1_))).
Variable finite_domain_2_83 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n2_) -> (X = n0_ \/ (X = n1_ \/ X = n2_)))).
Variable finite_domain_3_84 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n3_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ X = n3_))))).
Variable successor_4_85 : (succ_ (succ_ (succ_ (succ_ n0_)))) = n4_.
Variable successor_5_86 : (succ_ (succ_ (succ_ (succ_ (succ_ n0_))))) = n5_.
Variable successor_1_87 : (succ_ n0_) = n1_.
Variable successor_2_88 : (succ_ (succ_ n0_)) = n2_.
Variable successor_3_89 : (succ_ (succ_ (succ_ n0_))) = n3_.

Set Firstorder Depth 10.

Theorem quaternion_ds1_inuse_0009_90 : (((a_select2_ rho_defuse_ n0_) = use_ /\ ((a_select2_ rho_defuse_ n1_) = use_ /\ ((a_select2_ rho_defuse_ n2_) = use_ /\ ((a_select2_ sigma_defuse_ n0_) = use_ /\ ((a_select2_ sigma_defuse_ n1_) = use_ /\ ((a_select2_ sigma_defuse_ n2_) = use_ /\ ((a_select2_ sigma_defuse_ n3_) = use_ /\ ((a_select2_ sigma_defuse_ n4_) = use_ /\ ((a_select2_ sigma_defuse_ n5_) = use_ /\ ((a_select3_ u_defuse_ n0_ n0_) = use_ /\ ((a_select3_ u_defuse_ n1_ n0_) = use_ /\ ((a_select3_ u_defuse_ n2_ n0_) = use_ /\ ((a_select2_ xinit_defuse_ n3_) = use_ /\ ((a_select2_ xinit_defuse_ n4_) = use_ /\ ((a_select2_ xinit_defuse_ n5_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n0_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n1_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n2_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n3_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n4_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n5_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ (minus_ n999_ n1_) /\ ((forall A B : Universe, ((leq_ n0_ A /\ (leq_ n0_ B /\ (leq_ A n2_ /\ leq_ B pv5_))) -> ((a_select3_ u_defuse_ A B) = use_ /\ (a_select3_ z_defuse_ A B) = use_))) /\ (forall C D : Universe, ((leq_ n0_ C /\ (leq_ n0_ D /\ (leq_ C n2_ /\ leq_ D (minus_ pv5_ n1_)))) -> ((a_select3_ u_defuse_ C D) = use_ /\ (a_select3_ z_defuse_ C D) = use_))))))))))))))))))))))))))))))))) -> ((a_select2_ rho_defuse_ n0_) = use_ /\ ((a_select2_ rho_defuse_ n1_) = use_ /\ ((a_select2_ rho_defuse_ n2_) = use_ /\ ((a_select2_ sigma_defuse_ n0_) = use_ /\ ((a_select2_ sigma_defuse_ n1_) = use_ /\ ((a_select2_ sigma_defuse_ n2_) = use_ /\ ((a_select2_ sigma_defuse_ n3_) = use_ /\ ((a_select2_ sigma_defuse_ n4_) = use_ /\ ((a_select2_ sigma_defuse_ n5_) = use_ /\ ((a_select3_ u_defuse_ n0_ n0_) = use_ /\ ((a_select3_ u_defuse_ n1_ n0_) = use_ /\ ((a_select3_ u_defuse_ n2_ n0_) = use_ /\ ((a_select2_ xinit_defuse_ n3_) = use_ /\ ((a_select2_ xinit_defuse_ n4_) = use_ /\ ((a_select2_ xinit_defuse_ n5_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n0_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n1_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n2_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n3_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n4_) = use_ /\ ((a_select2_ xinit_mean_defuse_ n5_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n0_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n1_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n2_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n3_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n4_) = use_ /\ ((a_select2_ xinit_noise_defuse_ n5_) = use_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ (minus_ n999_ n1_) /\ ((forall E F : Universe, ((leq_ n0_ E /\ (leq_ n0_ F /\ (leq_ E n2_ /\ leq_ F pv5_))) -> ((a_select3_ u_defuse_ E F) = use_ /\ (a_select3_ z_defuse_ E F) = use_))) /\ (forall G H : Universe, ((leq_ n0_ G /\ (leq_ n0_ H /\ (leq_ G n2_ /\ leq_ H (minus_ pv5_ n1_)))) -> ((a_select3_ u_defuse_ G H) = use_ /\ (a_select3_ z_defuse_ G H) = use_)))))))))))))))))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
