(*
% File     : SWC001+1 : ILTP v1.1.2
% Domain   : Software Creation
% Problem  : cond_as_set_x_as_set
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.
% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [Wei00]
% Names    : cond_as_set_x_as_set [Wei00]
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.22 v2.7.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   96 (   9 unit)
%            Number of atoms       :  412 (  73 equality)
%            Maximal formula depth :   19 (   7 average)
%            Number of connectives :  347 (  31 ~  ;  14  |;  44  &)
%                                         (  26 <=>; 232 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   20 (   0 propositional; 1-2 arity)
%            Number of functors    :    5 (   1 constant; 0-2 arity)
%            Number of variables   :  209 (   0 singleton; 195 !;  14 ?)
%            Maximal term depth    :    4 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable totalorderedP_ : Universe -> Prop.
Variable EqCongruence_totalorderedP : forall x1 y1 : Universe, x1 = y1 -> totalorderedP_ x1 -> totalorderedP_ y1 .
Variable totalorderP_ : Universe -> Prop.
Variable EqCongruence_totalorderP : forall x1 y1 : Universe, x1 = y1 -> totalorderP_ x1 -> totalorderP_ y1 .
Variable strictorderedP_ : Universe -> Prop.
Variable EqCongruence_strictorderedP : forall x1 y1 : Universe, x1 = y1 -> strictorderedP_ x1 -> strictorderedP_ y1 .
Variable strictorderP_ : Universe -> Prop.
Variable EqCongruence_strictorderP : forall x1 y1 : Universe, x1 = y1 -> strictorderP_ x1 -> strictorderP_ y1 .
Variable ssList_ : Universe -> Prop.
Variable EqCongruence_ssList : forall x1 y1 : Universe, x1 = y1 -> ssList_ x1 -> ssList_ y1 .
Variable ssItem_ : Universe -> Prop.
Variable EqCongruence_ssItem : forall x1 y1 : Universe, x1 = y1 -> ssItem_ x1 -> ssItem_ y1 .
Variable singletonP_ : Universe -> Prop.
Variable EqCongruence_singletonP : forall x1 y1 : Universe, x1 = y1 -> singletonP_ x1 -> singletonP_ y1 .
Variable segmentP_ : Universe -> Universe -> Prop.
Variable EqCongruence_segmentP : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> segmentP_ x1 x2 -> segmentP_ y1 y2 .
Variable rearsegP_ : Universe -> Universe -> Prop.
Variable EqCongruence_rearsegP : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> rearsegP_ x1 x2 -> rearsegP_ y1 y2 .
Variable neq_ : Universe -> Universe -> Prop.
Variable EqCongruence_neq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> neq_ x1 x2 -> neq_ y1 y2 .
Variable memberP_ : Universe -> Universe -> Prop.
Variable EqCongruence_memberP : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> memberP_ x1 x2 -> memberP_ y1 y2 .
Variable lt_ : Universe -> Universe -> Prop.
Variable EqCongruence_lt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> lt_ x1 x2 -> lt_ y1 y2 .
Variable leq_ : Universe -> Universe -> Prop.
Variable EqCongruence_leq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> leq_ x1 x2 -> leq_ y1 y2 .
Variable gt_ : Universe -> Universe -> Prop.
Variable EqCongruence_gt : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> gt_ x1 x2 -> gt_ y1 y2 .
Variable geq_ : Universe -> Universe -> Prop.
Variable EqCongruence_geq : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> geq_ x1 x2 -> geq_ y1 y2 .
Variable frontsegP_ : Universe -> Universe -> Prop.
Variable EqCongruence_frontsegP : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> frontsegP_ x1 x2 -> frontsegP_ y1 y2 .
Variable equalelemsP_ : Universe -> Prop.
Variable EqCongruence_equalelemsP : forall x1 y1 : Universe, x1 = y1 -> equalelemsP_ x1 -> equalelemsP_ y1 .
Variable duplicatefreeP_ : Universe -> Prop.
Variable EqCongruence_duplicatefreeP : forall x1 y1 : Universe, x1 = y1 -> duplicatefreeP_ x1 -> duplicatefreeP_ y1 .
Variable cyclefreeP_ : Universe -> Prop.
Variable EqCongruence_cyclefreeP : forall x1 y1 : Universe, x1 = y1 -> cyclefreeP_ x1 -> cyclefreeP_ y1 .

Variable tl_ : Universe -> Universe.
Variable EqCongruence_tl : forall x1 y1 : Universe, x1 = y1 -> tl_ x1 = tl_ y1 .
Variable nil_ : Universe.
Variable hd_ : Universe -> Universe.
Variable EqCongruence_hd : forall x1 y1 : Universe, x1 = y1 -> hd_ x1 = hd_ y1 .
Variable cons_ : Universe -> Universe -> Universe.
Variable EqCongruence_cons : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cons_ x1 x2 = cons_ y1 y2 .
Variable app_ : Universe -> Universe -> Universe.
Variable EqCongruence_app : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> app_ x1 x2 = app_ y1 y2 .

Variable ax1_1 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (neq_ U V <-> U <> V))))).
Variable ax2_2 : (exists U : Universe, (ssItem_ U /\ (exists V : Universe, (ssItem_ V /\ U <> V)))).
Variable ax3_3 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (memberP_ U V <-> (exists W : Universe, (ssList_ W /\ (exists X : Universe, (ssList_ X /\ (app_ W (cons_ V X)) = U))))))))).
Variable ax4_4 : (forall U : Universe, (ssList_ U -> (singletonP_ U <-> (exists V : Universe, (ssItem_ V /\ (cons_ V nil_) = U))))).
Variable ax5_5 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (frontsegP_ U V <-> (exists W : Universe, (ssList_ W /\ (app_ V W) = U))))))).
Variable ax6_6 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (rearsegP_ U V <-> (exists W : Universe, (ssList_ W /\ (app_ W V) = U))))))).
Variable ax7_7 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (segmentP_ U V <-> (exists W : Universe, (ssList_ W /\ (exists X : Universe, (ssList_ X /\ (app_ (app_ W V) X) = U))))))))).
Variable ax8_8 : (forall U : Universe, (ssList_ U -> (cyclefreeP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> ~((leq_ V W /\ leq_ W V)))))))))))))))).
Variable ax9_9 : (forall U : Universe, (ssList_ U -> (totalorderP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> (leq_ V W \/ leq_ W V))))))))))))))).
Variable ax10_10 : (forall U : Universe, (ssList_ U -> (strictorderP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> (lt_ V W \/ lt_ W V))))))))))))))).
Variable ax11_11 : (forall U : Universe, (ssList_ U -> (totalorderedP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> leq_ V W)))))))))))))).
Variable ax12_12 : (forall U : Universe, (ssList_ U -> (strictorderedP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> lt_ V W)))))))))))))).
Variable ax13_13 : (forall U : Universe, (ssList_ U -> (duplicatefreeP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> V <> W)))))))))))))).
Variable ax14_14 : (forall U : Universe, (ssList_ U -> (equalelemsP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> ((app_ X (cons_ V (cons_ W Y))) = U -> V = W)))))))))))).
Variable ax15_15 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (neq_ U V <-> U <> V))))).
Variable ax16_16 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> ssList_ (cons_ V U))))).
Variable ax17_17 : ssList_ nil_.
Variable ax18_18 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (cons_ V U) <> U)))).
Variable ax19_19 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssItem_ X -> ((cons_ W U) = (cons_ X V) -> (W = X /\ V = U)))))))))).
Variable ax20_20 : (forall U : Universe, (ssList_ U -> (nil_ = U \/ (exists V : Universe, (ssList_ V /\ (exists W : Universe, (ssItem_ W /\ (cons_ W V) = U))))))).
Variable ax21_21 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> nil_ <> (cons_ V U))))).
Variable ax22_22 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> ssItem_ (hd_ U)))).
Variable ax23_23 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (hd_ (cons_ V U)) = V)))).
Variable ax24_24 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> ssList_ (tl_ U)))).
Variable ax25_25 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (tl_ (cons_ V U)) = U)))).
Variable ax26_26 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ssList_ (app_ U V))))).
Variable ax27_27 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssItem_ W -> (cons_ W (app_ V U)) = (app_ (cons_ W V) U))))))).
Variable ax28_28 : (forall U : Universe, (ssList_ U -> (app_ nil_ U) = U)).
Variable ax29_29 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> ((leq_ U V /\ leq_ V U) -> U = V))))).
Variable ax30_30 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((leq_ U V /\ leq_ V W) -> leq_ U W))))))).
Variable ax31_31 : (forall U : Universe, (ssItem_ U -> leq_ U U)).
Variable ax32_32 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (geq_ U V <-> leq_ V U))))).
Variable ax33_33 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (lt_ U V -> ~(lt_ V U)))))).
Variable ax34_34 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((lt_ U V /\ lt_ V W) -> lt_ U W))))))).
Variable ax35_35 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (gt_ U V <-> lt_ V U))))).
Variable ax36_36 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (memberP_ (app_ V W) U <-> (memberP_ V U \/ memberP_ W U)))))))).
Variable ax37_37 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssList_ W -> (memberP_ (cons_ V W) U <-> (U = V \/ memberP_ W U)))))))).
Variable ax38_38 : (forall U : Universe, (ssItem_ U -> ~(memberP_ nil_ U))).
Variable ax39_39 : ~(singletonP_ nil_).
Variable ax40_40 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((frontsegP_ U V /\ frontsegP_ V W) -> frontsegP_ U W))))))).
Variable ax41_41 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((frontsegP_ U V /\ frontsegP_ V U) -> U = V))))).
Variable ax42_42 : (forall U : Universe, (ssList_ U -> frontsegP_ U U)).
Variable ax43_43 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (frontsegP_ U V -> frontsegP_ (app_ U W) V))))))).
Variable ax44_44 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssList_ W -> (forall X : Universe, (ssList_ X -> (frontsegP_ (cons_ U W) (cons_ V X) <-> (U = V /\ frontsegP_ W X)))))))))).
Variable ax45_45 : (forall U : Universe, (ssList_ U -> frontsegP_ U nil_)).
Variable ax46_46 : (forall U : Universe, (ssList_ U -> (frontsegP_ nil_ U <-> nil_ = U))).
Variable ax47_47 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((rearsegP_ U V /\ rearsegP_ V W) -> rearsegP_ U W))))))).
Variable ax48_48 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((rearsegP_ U V /\ rearsegP_ V U) -> U = V))))).
Variable ax49_49 : (forall U : Universe, (ssList_ U -> rearsegP_ U U)).
Variable ax50_50 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (rearsegP_ U V -> rearsegP_ (app_ W U) V))))))).
Variable ax51_51 : (forall U : Universe, (ssList_ U -> rearsegP_ U nil_)).
Variable ax52_52 : (forall U : Universe, (ssList_ U -> (rearsegP_ nil_ U <-> nil_ = U))).
Variable ax53_53 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((segmentP_ U V /\ segmentP_ V W) -> segmentP_ U W))))))).
Variable ax54_54 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((segmentP_ U V /\ segmentP_ V U) -> U = V))))).
Variable ax55_55 : (forall U : Universe, (ssList_ U -> segmentP_ U U)).
Variable ax56_56 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (forall X : Universe, (ssList_ X -> (segmentP_ U V -> segmentP_ (app_ (app_ W U) X) V))))))))).
Variable ax57_57 : (forall U : Universe, (ssList_ U -> segmentP_ U nil_)).
Variable ax58_58 : (forall U : Universe, (ssList_ U -> (segmentP_ nil_ U <-> nil_ = U))).
Variable ax59_59 : (forall U : Universe, (ssItem_ U -> cyclefreeP_ (cons_ U nil_))).
Variable ax60_60 : cyclefreeP_ nil_.
Variable ax61_61 : (forall U : Universe, (ssItem_ U -> totalorderP_ (cons_ U nil_))).
Variable ax62_62 : totalorderP_ nil_.
Variable ax63_63 : (forall U : Universe, (ssItem_ U -> strictorderP_ (cons_ U nil_))).
Variable ax64_64 : strictorderP_ nil_.
Variable ax65_65 : (forall U : Universe, (ssItem_ U -> totalorderedP_ (cons_ U nil_))).
Variable ax66_66 : totalorderedP_ nil_.
Variable ax67_67 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssList_ V -> (totalorderedP_ (cons_ U V) <-> (nil_ = V \/ (nil_ <> V /\ (totalorderedP_ V /\ leq_ U (hd_ V))))))))).
Variable ax68_68 : (forall U : Universe, (ssItem_ U -> strictorderedP_ (cons_ U nil_))).
Variable ax69_69 : strictorderedP_ nil_.
Variable ax70_70 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssList_ V -> (strictorderedP_ (cons_ U V) <-> (nil_ = V \/ (nil_ <> V /\ (strictorderedP_ V /\ lt_ U (hd_ V))))))))).
Variable ax71_71 : (forall U : Universe, (ssItem_ U -> duplicatefreeP_ (cons_ U nil_))).
Variable ax72_72 : duplicatefreeP_ nil_.
Variable ax73_73 : (forall U : Universe, (ssItem_ U -> equalelemsP_ (cons_ U nil_))).
Variable ax74_74 : equalelemsP_ nil_.
Variable ax75_75 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> (exists V : Universe, (ssItem_ V /\ (hd_ U) = V))))).
Variable ax76_76 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> (exists V : Universe, (ssList_ V /\ (tl_ U) = V))))).
Variable ax77_77 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((nil_ <> V /\ (nil_ <> U /\ ((hd_ V) = (hd_ U) /\ (tl_ V) = (tl_ U)))) -> V = U))))).
Variable ax78_78 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> (cons_ (hd_ U) (tl_ U)) = U))).
Variable ax79_79 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((app_ W V) = (app_ U V) -> W = U))))))).
Variable ax80_80 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((app_ V W) = (app_ V U) -> W = U))))))).
Variable ax81_81 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (cons_ V U) = (app_ (cons_ V nil_) U))))).
Variable ax82_82 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (app_ (app_ U V) W) = (app_ U (app_ V W)))))))).
Variable ax83_83 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (nil_ = (app_ U V) <-> (nil_ = V /\ nil_ = U)))))).
Variable ax84_84 : (forall U : Universe, (ssList_ U -> (app_ U nil_) = U)).
Variable ax85_85 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (nil_ <> U -> (hd_ (app_ U V)) = (hd_ U)))))).
Variable ax86_86 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (nil_ <> U -> (tl_ (app_ U V)) = (app_ (tl_ U) V)))))).
Variable ax87_87 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> ((geq_ U V /\ geq_ V U) -> U = V))))).
Variable ax88_88 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((geq_ U V /\ geq_ V W) -> geq_ U W))))))).
Variable ax89_89 : (forall U : Universe, (ssItem_ U -> geq_ U U)).
Variable ax90_90 : (forall U : Universe, (ssItem_ U -> ~(lt_ U U))).
Variable ax91_91 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((leq_ U V /\ lt_ V W) -> lt_ U W))))))).
Variable ax92_92 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (leq_ U V -> (U = V \/ lt_ U V)))))).
Variable ax93_93 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (lt_ U V <-> (U <> V /\ leq_ U V)))))).
Variable ax94_94 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (gt_ U V -> ~(gt_ V U)))))).
Variable ax95_95 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((gt_ U V /\ gt_ V W) -> gt_ U W))))))).

Set Firstorder Depth 10.

Theorem co1_96 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (forall X : Universe, (ssList_ X -> (V <> X \/ (U <> W \/ (~(duplicatefreeP_ W) \/ ((exists Y : Universe, (ssItem_ Y /\ ((~(memberP_ X Y) /\ memberP_ W Y) \/ (~(memberP_ W Y) /\ memberP_ X Y)))) \/ ((forall Z : Universe, (ssItem_ Z -> ((~(memberP_ V Z) /\ ~(memberP_ U Z)) \/ (memberP_ V Z /\ memberP_ U Z)))) /\ duplicatefreeP_ U))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
