(*
% File     : SET768+4 : ILTP v1.1.2
% Domain   : Set Theory (Equivalence relations)
% Problem  : Equality of equivalence classes 1
% Version  : [Pas99] axioms.
% English  : Two equivalence classes are equal if and only if the members 
%            are equivalent.
% Refs     : [Pas99] Pastre (1999), Email to G. Sutcliffe
% Source   : [Pas99]
% Names    :
% Status   : Theorem
% Rating   : 0.91 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 0.86 v2.5.0, 0.88 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   17 (   1 unit)
%            Number of atoms       :   73 (   4 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   59 (   3 ~  ;   2  |;  23  &)
%                                         (  16 <=>;  15 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 2-3 arity)
%            Number of functors    :   10 (   1 constant; 0-3 arity)
%            Number of variables   :   61 (   0 singleton;  57 !;   4 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable pre_order_ : Universe -> Universe -> Prop.
Variable EqCongruence_pre_order : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> pre_order_ x1 x2 -> pre_order_ y1 y2 .
Variable partition_ : Universe -> Universe -> Prop.
Variable EqCongruence_partition : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> partition_ x1 x2 -> partition_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable equivalence_ : Universe -> Universe -> Prop.
Variable EqCongruence_equivalence : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> equivalence_ x1 x2 -> equivalence_ y1 y2 .
Variable equal_set_ : Universe -> Universe -> Prop.
Variable EqCongruence_equal_set : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> equal_set_ x1 x2 -> equal_set_ y1 y2 .
Variable disjoint_ : Universe -> Universe -> Prop.
Variable EqCongruence_disjoint : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disjoint_ x1 x2 -> disjoint_ y1 y2 .
Variable apply_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_apply : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> apply_ x1 x2 x3 -> apply_ y1 y2 y3 .

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_unordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unordered_pair_ x1 x2 = unordered_pair_ y1 y2 .
Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable sum_ : Universe -> Universe.
Variable EqCongruence_sum : forall x1 y1 : Universe, x1 = y1 -> sum_ x1 = sum_ y1 .
Variable singleton_ : Universe -> Universe.
Variable EqCongruence_singleton : forall x1 y1 : Universe, x1 = y1 -> singleton_ x1 = singleton_ y1 .
Variable product_ : Universe -> Universe.
Variable EqCongruence_product : forall x1 y1 : Universe, x1 = y1 -> product_ x1 = product_ y1 .
Variable power_set_ : Universe -> Universe.
Variable EqCongruence_power_set : forall x1 y1 : Universe, x1 = y1 -> power_set_ x1 = power_set_ y1 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable equivalence_class_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_equivalence_class : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> equivalence_class_ x1 x2 x3 = equivalence_class_ y1 y2 y3 .
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable subset_1 : (forall A B : Universe, (subset_ A B <-> (forall X : Universe, (member_ X A -> member_ X B)))).
Variable equal_set_2 : (forall A B : Universe, (equal_set_ A B <-> (subset_ A B /\ subset_ B A))).
Variable power_set_3 : (forall X A : Universe, (member_ X (power_set_ A) <-> subset_ X A)).
Variable intersection_4 : (forall X A B : Universe, (member_ X (intersection_ A B) <-> (member_ X A /\ member_ X B))).
Variable union_5 : (forall X A B : Universe, (member_ X (union_ A B) <-> (member_ X A \/ member_ X B))).
Variable empty_set_6 : (forall X : Universe, ~(member_ X empty_set_)).
Variable difference_7 : (forall B A E : Universe, (member_ B (difference_ E A) <-> (member_ B E /\ ~(member_ B A)))).
Variable singleton_8 : (forall X A : Universe, (member_ X (singleton_ A) <-> X = A)).
Variable unordered_pair_9 : (forall X A B : Universe, (member_ X (unordered_pair_ A B) <-> (X = A \/ X = B))).
Variable sum_10 : (forall X A : Universe, (member_ X (sum_ A) <-> (exists Y : Universe, (member_ Y A /\ member_ X Y)))).
Variable product_11 : (forall X A : Universe, (member_ X (product_ A) <-> (forall Y : Universe, (member_ Y A -> member_ X Y)))).
Variable disjoint_12 : (forall A B : Universe, (disjoint_ A B <-> ~((exists X : Universe, (member_ X A /\ member_ X B))))).
Variable partition_13 : (forall A E : Universe, (partition_ A E <-> ((forall X : Universe, (member_ X A -> subset_ X E)) /\ ((forall X : Universe, (member_ X E -> (exists Y : Universe, (member_ Y A /\ member_ X Y)))) /\ (forall X Y : Universe, ((member_ X A /\ member_ Y A) -> ((exists Z : Universe, (member_ Z X /\ member_ Z Y)) -> X = Y))))))).
Variable equivalence_14 : (forall A R : Universe, (equivalence_ R A <-> ((forall X : Universe, (member_ X A -> apply_ R X X)) /\ ((forall X Y : Universe, ((member_ X A /\ member_ Y A) -> (apply_ R X Y -> apply_ R Y X))) /\ (forall X Y Z : Universe, ((member_ X A /\ (member_ Y A /\ member_ Z A)) -> ((apply_ R X Y /\ apply_ R Y Z) -> apply_ R X Z))))))).
Variable equivalence_class_15 : (forall R E A X : Universe, (member_ X (equivalence_class_ A E R) <-> (member_ X E /\ apply_ R A X))).
Variable pre_order_16 : (forall R E : Universe, (pre_order_ R E <-> ((forall X : Universe, (member_ X E -> apply_ R X X)) /\ (forall X Y Z : Universe, ((member_ X E /\ (member_ Y E /\ member_ Z E)) -> ((apply_ R X Y /\ apply_ R Y Z) -> apply_ R X Z)))))).

Set Firstorder Depth 10.

Theorem thIII04_17 : (forall E R A B : Universe, ((equivalence_ R E /\ (member_ A E /\ member_ B E)) -> (equal_set_ (equivalence_class_ A E R) (equivalence_class_ B E R) <-> apply_ R A B))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
