(*
% File     : SET750+4 : ILTP v1.1.2
% Domain   : Set Theory (Mappings)
% Problem  : Property of isomorphism
% Version  : [Pas99] axioms.
% English  : If F is one-to-one, then F is an isomorphism if and only if
%            F and its inverse are increasing.
% Refs     : [Pas99] Pastre (1999), Email to G. Sutcliffe
% Source   : [Pas99]
% Names    :
% Status   : Theorem
% Rating   : 0.91 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 0.86 v2.5.0, 0.88 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   29 (   1 unit)
%            Number of atoms       :  133 (   6 equality)
%            Maximal formula depth :   19 (   9 average)
%            Number of connectives :  106 (   2 ~  ;   2  |;  52  &)
%                                         (  31 <=>;  19 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 2-6 arity)
%            Number of functors    :   15 (   1 constant; 0-5 arity)
%            Number of variables   :  138 (   0 singleton; 129 !;   9 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
% Bugfixes : v2.2.1 - Bugfixes in SET006+1.ax.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable surjective_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_surjective : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> surjective_ x1 x2 x3 -> surjective_ y1 y2 y3 .
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable one_to_one_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_one_to_one : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> one_to_one_ x1 x2 x3 -> one_to_one_ y1 y2 y3 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable maps_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_maps : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> maps_ x1 x2 x3 -> maps_ y1 y2 y3 .
Variable isomorphism_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_isomorphism : forall x1 x2 x3 x4 x5 y1 y2 y3 y4 y5 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> x5 = y5 -> isomorphism_ x1 x2 x3 x4 x5 -> isomorphism_ y1 y2 y3 y4 y5 .
Variable inverse_predicate_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_inverse_predicate : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> inverse_predicate_ x1 x2 x3 x4 -> inverse_predicate_ y1 y2 y3 y4 .
Variable injective_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_injective : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> injective_ x1 x2 x3 -> injective_ y1 y2 y3 .
Variable increasing_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_increasing : forall x1 x2 x3 x4 x5 y1 y2 y3 y4 y5 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> x5 = y5 -> increasing_ x1 x2 x3 x4 x5 -> increasing_ y1 y2 y3 y4 y5 .
Variable identity_ : Universe -> Universe -> Prop.
Variable EqCongruence_identity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> identity_ x1 x2 -> identity_ y1 y2 .
Variable equal_set_ : Universe -> Universe -> Prop.
Variable EqCongruence_equal_set : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> equal_set_ x1 x2 -> equal_set_ y1 y2 .
Variable equal_maps_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_equal_maps : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> equal_maps_ x1 x2 x3 x4 -> equal_maps_ y1 y2 y3 y4 .
Variable decreasing_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_decreasing : forall x1 x2 x3 x4 x5 y1 y2 y3 y4 y5 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> x5 = y5 -> decreasing_ x1 x2 x3 x4 x5 -> decreasing_ y1 y2 y3 y4 y5 .
Variable compose_predicate_ : Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_compose_predicate : forall x1 x2 x3 x4 x5 x6 y1 y2 y3 y4 y5 y6 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> x5 = y5 -> x6 = y6 -> compose_predicate_ x1 x2 x3 x4 x5 x6 -> compose_predicate_ y1 y2 y3 y4 y5 y6 .
Variable apply_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_apply : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> apply_ x1 x2 x3 -> apply_ y1 y2 y3 .

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_unordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unordered_pair_ x1 x2 = unordered_pair_ y1 y2 .
Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable sum_ : Universe -> Universe.
Variable EqCongruence_sum : forall x1 y1 : Universe, x1 = y1 -> sum_ x1 = sum_ y1 .
Variable singleton_ : Universe -> Universe.
Variable EqCongruence_singleton : forall x1 y1 : Universe, x1 = y1 -> singleton_ x1 = singleton_ y1 .
Variable product_ : Universe -> Universe.
Variable EqCongruence_product : forall x1 y1 : Universe, x1 = y1 -> product_ x1 = product_ y1 .
Variable power_set_ : Universe -> Universe.
Variable EqCongruence_power_set : forall x1 y1 : Universe, x1 = y1 -> power_set_ x1 = power_set_ y1 .
Variable inverse_image3_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_inverse_image3 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> inverse_image3_ x1 x2 x3 = inverse_image3_ y1 y2 y3 .
Variable inverse_image2_ : Universe -> Universe -> Universe.
Variable EqCongruence_inverse_image2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> inverse_image2_ x1 x2 = inverse_image2_ y1 y2 .
Variable inverse_function_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_inverse_function : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> inverse_function_ x1 x2 x3 = inverse_function_ y1 y2 y3 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable image3_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_image3 : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> image3_ x1 x2 x3 = image3_ y1 y2 y3 .
Variable image2_ : Universe -> Universe -> Universe.
Variable EqCongruence_image2 : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> image2_ x1 x2 = image2_ y1 y2 .
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .
Variable compose_function_ : Universe -> Universe -> Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_compose_function : forall x1 x2 x3 x4 x5 y1 y2 y3 y4 y5 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> x5 = y5 -> compose_function_ x1 x2 x3 x4 x5 = compose_function_ y1 y2 y3 y4 y5 .

Variable subset_1 : (forall A B : Universe, (subset_ A B <-> (forall X : Universe, (member_ X A -> member_ X B)))).
Variable equal_set_2 : (forall A B : Universe, (equal_set_ A B <-> (subset_ A B /\ subset_ B A))).
Variable power_set_3 : (forall X A : Universe, (member_ X (power_set_ A) <-> subset_ X A)).
Variable intersection_4 : (forall X A B : Universe, (member_ X (intersection_ A B) <-> (member_ X A /\ member_ X B))).
Variable union_5 : (forall X A B : Universe, (member_ X (union_ A B) <-> (member_ X A \/ member_ X B))).
Variable empty_set_6 : (forall X : Universe, ~(member_ X empty_set_)).
Variable difference_7 : (forall B A E : Universe, (member_ B (difference_ E A) <-> (member_ B E /\ ~(member_ B A)))).
Variable singleton_8 : (forall X A : Universe, (member_ X (singleton_ A) <-> X = A)).
Variable unordered_pair_9 : (forall X A B : Universe, (member_ X (unordered_pair_ A B) <-> (X = A \/ X = B))).
Variable sum_10 : (forall X A : Universe, (member_ X (sum_ A) <-> (exists Y : Universe, (member_ Y A /\ member_ X Y)))).
Variable product_11 : (forall X A : Universe, (member_ X (product_ A) <-> (forall Y : Universe, (member_ Y A -> member_ X Y)))).
Variable maps_12 : (forall F A B : Universe, (maps_ F A B <-> ((forall X : Universe, (member_ X A -> (exists Y : Universe, (member_ Y B /\ apply_ F X Y)))) /\ (forall X Y1 Y2 : Universe, ((member_ X A /\ (member_ Y1 B /\ member_ Y2 B)) -> ((apply_ F X Y1 /\ apply_ F X Y2) -> Y1 = Y2)))))).
Variable compose_predicate_13 : (forall H G F A B C : Universe, (compose_predicate_ H G F A B C <-> (forall X Z : Universe, ((member_ X A /\ member_ Z C) -> (apply_ H X Z <-> (exists Y : Universe, (member_ Y B /\ (apply_ F X Y /\ apply_ G Y Z)))))))).
Variable compose_function_14 : (forall G F A B C X Z : Universe, ((member_ X A /\ member_ Z C) -> (apply_ (compose_function_ G F A B C) X Z <-> (exists Y : Universe, (member_ Y B /\ (apply_ F X Y /\ apply_ G Y Z)))))).
Variable equal_maps_15 : (forall F G A B : Universe, (equal_maps_ F G A B <-> (forall X Y1 Y2 : Universe, ((member_ X A /\ (member_ Y1 B /\ member_ Y2 B)) -> ((apply_ F X Y1 /\ apply_ G X Y2) -> Y1 = Y2))))).
Variable identity_16 : (forall F A : Universe, (identity_ F A <-> (forall X : Universe, (member_ X A -> apply_ F X X)))).
Variable injective_17 : (forall F A B : Universe, (injective_ F A B <-> (forall X1 X2 Y : Universe, ((member_ X1 A /\ (member_ X2 A /\ member_ Y B)) -> ((apply_ F X1 Y /\ apply_ F X2 Y) -> X1 = X2))))).
Variable surjective_18 : (forall F A B : Universe, (surjective_ F A B <-> (forall Y : Universe, (member_ Y B -> (exists E : Universe, (member_ E A /\ apply_ F E Y)))))).
Variable one_to_one_19 : (forall F A B : Universe, (one_to_one_ F A B <-> (injective_ F A B /\ surjective_ F A B))).
Variable inverse_predicate_20 : (forall G F A B : Universe, (inverse_predicate_ G F A B <-> (forall X Y : Universe, ((member_ X A /\ member_ Y B) -> (apply_ F X Y <-> apply_ G Y X))))).
Variable inverse_function_21 : (forall F A B X Y : Universe, ((member_ X A /\ member_ Y B) -> (apply_ F X Y <-> apply_ (inverse_function_ F A B) Y X))).
Variable image2_22 : (forall F A Y : Universe, (member_ Y (image2_ F A) <-> (exists X : Universe, (member_ X A /\ apply_ F X Y)))).
Variable image3_23 : (forall F A B Y : Universe, (member_ Y (image3_ F A B) <-> (member_ Y B /\ (exists X : Universe, (member_ X A /\ apply_ F X Y))))).
Variable inverse_image2_24 : (forall F B X : Universe, (member_ X (inverse_image2_ F B) <-> (exists Y : Universe, (member_ Y B /\ apply_ F X Y)))).
Variable inverse_image3_25 : (forall F B A X : Universe, (member_ X (inverse_image3_ F B A) <-> (member_ X A /\ (exists Y : Universe, (member_ Y B /\ apply_ F X Y))))).
Variable increasing_function_26 : (forall F A R B S : Universe, (increasing_ F A R B S <-> (forall X1 Y1 X2 Y2 : Universe, ((member_ X1 A /\ (member_ Y1 B /\ (member_ X2 A /\ (member_ Y2 B /\ (apply_ R X1 X2 /\ (apply_ F X1 Y1 /\ apply_ F X2 Y2)))))) -> apply_ S Y1 Y2)))).
Variable decreasing_function_27 : (forall F A R B S : Universe, (decreasing_ F A R B S <-> (forall X1 Y1 X2 Y2 : Universe, ((member_ X1 A /\ (member_ Y1 B /\ (member_ X2 A /\ (member_ Y2 B /\ (apply_ R X1 X2 /\ (apply_ F X1 Y1 /\ apply_ F X2 Y2)))))) -> apply_ S Y2 Y1)))).
Variable isomorphism_28 : (forall F A R B S : Universe, (isomorphism_ F A R B S <-> (maps_ F A B /\ (one_to_one_ F A B /\ (forall X1 Y1 X2 Y2 : Universe, ((member_ X1 A /\ (member_ Y1 B /\ (member_ X2 A /\ (member_ Y2 B /\ (apply_ F X1 Y1 /\ apply_ F X2 Y2))))) -> (apply_ R X1 X2 <-> apply_ S Y1 Y2))))))).

Set Firstorder Depth 10.

Theorem thII41_29 : (forall F A B R S : Universe, ((maps_ F A B /\ one_to_one_ F A B) -> (isomorphism_ F A R B S <-> (increasing_ F A R B S /\ increasing_ (inverse_function_ F A B) B S A R)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
