(*
% File     : SET685+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : y in R (X to Y) o D1 iff ?x in D : <x,y> in R & x in D1
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : y is in a relation R from X to Y composed with D1 iff there 
%            exists an element x in D such that <x,y> is in R and x is in D1.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (52) [Wor89]
% Status   : Theorem
% Rating   : 0.45 v3.1.0, 0.56 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   28 (   2 unit)
%            Number of atoms       :  123 (   6 equality)
%            Maximal formula depth :   15 (   7 average)
%            Number of connectives :  102 (   7 ~  ;   0  |;  16  &)
%                                         (  11 <=>;  68 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :   12 (   2 constant; 0-4 arity)
%            Number of variables   :   74 (   0 singleton;  66 !;   8 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable relation_like_ : Universe -> Prop.
Variable EqCongruence_relation_like : forall x1 y1 : Universe, x1 = y1 -> relation_like_ x1 -> relation_like_ y1 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable EqCongruence_ilf_type : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ilf_type_ x1 x2 -> ilf_type_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_unordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unordered_pair_ x1 x2 = unordered_pair_ y1 y2 .
Variable subset_type_ : Universe -> Universe.
Variable EqCongruence_subset_type : forall x1 y1 : Universe, x1 = y1 -> subset_type_ x1 = subset_type_ y1 .
Variable singleton_ : Universe -> Universe.
Variable EqCongruence_singleton : forall x1 y1 : Universe, x1 = y1 -> singleton_ x1 = singleton_ y1 .
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable EqCongruence_relation_type : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relation_type_ x1 x2 = relation_type_ y1 y2 .
Variable power_set_ : Universe -> Universe.
Variable EqCongruence_power_set : forall x1 y1 : Universe, x1 = y1 -> power_set_ x1 = power_set_ y1 .
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_ordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ordered_pair_ x1 x2 = ordered_pair_ y1 y2 .
Variable member_type_ : Universe -> Universe.
Variable EqCongruence_member_type : forall x1 y1 : Universe, x1 = y1 -> member_type_ x1 = member_type_ y1 .
Variable image4_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_image4 : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> image4_ x1 x2 x3 x4 = image4_ y1 y2 y3 y4 .
Variable image_ : Universe -> Universe -> Universe.
Variable EqCongruence_image : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> image_ x1 x2 = image_ y1 y2 .
Variable cross_product_ : Universe -> Universe -> Universe.
Variable EqCongruence_cross_product : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cross_product_ x1 x2 = cross_product_ y1 y2 .
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D binary_relation_type_ -> (member_ C (image_ D B) <-> (exists E : Universe, (ilf_type_ E set_type_ /\ (member_ (ordered_pair_ E C) D /\ member_ E B)))))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> (forall F : Universe, (ilf_type_ F (relation_type_ B C) -> (member_ (ordered_pair_ D E) F -> (member_ D B /\ member_ E C)))))))))))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> (forall F : Universe, (ilf_type_ F set_type_ -> (F = (ordered_pair_ D E) <-> F = (unordered_pair_ (unordered_pair_ D E) (singleton_ D))))))))))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p8_8 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> ilf_type_ (singleton_ B) set_type_)).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (unordered_pair_ B C) set_type_)))).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (unordered_pair_ B C) = (unordered_pair_ C B))))).
Variable p14_14 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (image_ B C) set_type_)))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p16_16 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (B = C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B <-> member_ D C)))))))).
Variable p20_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p21_21 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p23_23 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p24_24 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p25_25 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E set_type_ -> (image4_ B C D E) = (image_ D E))))))))).
Variable p26_26 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E set_type_ -> ilf_type_ (image4_ B C D E) (subset_type_ C))))))))).
Variable p27_27 : (forall B : Universe, ilf_type_ B set_type_).

Set Firstorder Depth 10.

Theorem prove_relset_1_52_28 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (forall D : Universe, ((~(empty_ D) /\ ilf_type_ D set_type_) -> (forall E : Universe, (ilf_type_ E (relation_type_ D B) -> (forall F : Universe, (ilf_type_ F (member_type_ B) -> (member_ F (image4_ D B E C) <-> (exists G : Universe, (ilf_type_ G (member_type_ D) /\ (member_ (ordered_pair_ G F) E /\ member_ G C)))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
