(*
% File     : SET659+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : For every x in X ? y : <x,y> in R (X to Y) iff domain of R is X
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : For every x in X there exists y such that <x,y> is in a 
%            relation R from X to Y iff the domain of R is X.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (22) [Wor89]
% Status   : Theorem
% Rating   : 0.64 v3.1.0, 0.78 v2.7.0, 0.67 v2.6.0, 0.71 v2.5.0, 0.75 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   35 (   2 unit)
%            Number of atoms       :  141 (  10 equality)
%            Maximal formula depth :   13 (   6 average)
%            Number of connectives :  110 (   4 ~  ;   0  |;  12  &)
%                                         (  14 <=>;  80 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :   14 (   2 constant; 0-3 arity)
%            Number of variables   :   83 (   0 singleton;  75 !;   8 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable relation_like_ : Universe -> Prop.
Variable EqCongruence_relation_like : forall x1 y1 : Universe, x1 = y1 -> relation_like_ x1 -> relation_like_ y1 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable EqCongruence_ilf_type : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ilf_type_ x1 x2 -> ilf_type_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_unordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unordered_pair_ x1 x2 = unordered_pair_ y1 y2 .
Variable subset_type_ : Universe -> Universe.
Variable EqCongruence_subset_type : forall x1 y1 : Universe, x1 = y1 -> subset_type_ x1 = subset_type_ y1 .
Variable singleton_ : Universe -> Universe.
Variable EqCongruence_singleton : forall x1 y1 : Universe, x1 = y1 -> singleton_ x1 = singleton_ y1 .
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable EqCongruence_relation_type : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relation_type_ x1 x2 = relation_type_ y1 y2 .
Variable range_of_ : Universe -> Universe.
Variable EqCongruence_range_of : forall x1 y1 : Universe, x1 = y1 -> range_of_ x1 = range_of_ y1 .
Variable range_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_range : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> range_ x1 x2 x3 = range_ y1 y2 y3 .
Variable power_set_ : Universe -> Universe.
Variable EqCongruence_power_set : forall x1 y1 : Universe, x1 = y1 -> power_set_ x1 = power_set_ y1 .
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_ordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ordered_pair_ x1 x2 = ordered_pair_ y1 y2 .
Variable member_type_ : Universe -> Universe.
Variable EqCongruence_member_type : forall x1 y1 : Universe, x1 = y1 -> member_type_ x1 = member_type_ y1 .
Variable domain_of_ : Universe -> Universe.
Variable EqCongruence_domain_of : forall x1 y1 : Universe, x1 = y1 -> domain_of_ x1 = domain_of_ y1 .
Variable domain_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_domain : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> domain_ x1 x2 x3 = domain_ y1 y2 y3 .
Variable cross_product_ : Universe -> Universe -> Universe.
Variable EqCongruence_cross_product : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cross_product_ x1 x2 = cross_product_ y1 y2 .
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C (domain_of_ B) <-> (exists D : Universe, (ilf_type_ D set_type_ /\ member_ (ordered_pair_ C D) B))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (domain_of_ B) set_type_)).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D binary_relation_type_ -> (member_ (ordered_pair_ B C) D -> (member_ B (domain_of_ D) /\ member_ C (range_of_ D))))))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B <-> member_ D C))) -> B = C))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> (forall F : Universe, (ilf_type_ F set_type_ -> (F = (ordered_pair_ D E) <-> F = (unordered_pair_ (unordered_pair_ D E) (singleton_ D))))))))))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p8_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (B = C <-> (subset_ B C /\ subset_ C B)))))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> ilf_type_ (singleton_ B) set_type_)).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (range_of_ B) set_type_)).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (unordered_pair_ B C) set_type_)))).
Variable p14_14 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (unordered_pair_ B C) = (unordered_pair_ C B))))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p16_16 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (B = C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B <-> member_ D C)))))))).
Variable p20_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p21_21 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p23_23 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p24_24 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p25_25 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p26_26 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p27_27 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p28_28 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p29_29 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p30_30 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (domain_ B C D) = (domain_of_ D))))))).
Variable p31_31 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (domain_ B C D) (subset_type_ B))))))).
Variable p32_32 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (range_ B C D) = (range_of_ D))))))).
Variable p33_33 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (range_ B C D) (subset_type_ C))))))).
Variable p34_34 : (forall B : Universe, ilf_type_ B set_type_).

Set Firstorder Depth 10.

Theorem prove_relset_1_22_35 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ C B) -> ((forall E : Universe, (ilf_type_ E set_type_ -> (member_ E C -> (exists F : Universe, (ilf_type_ F set_type_ /\ member_ (ordered_pair_ E F) D))))) <-> (domain_ C B D) = C))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
