(*
% File     : SET655+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : X a subset of X1 & Y a subset of Y1 => R (X to Y) is (X1 to Y1)
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : If X is a subset of X1 and Y is a subset of Y1 then a relation 
%            R from X to Y is a relation from X1 to Y1.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (17) [Wor89]
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.22 v2.7.0, 0.33 v2.6.0, 0.29 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   20 (   1 unit)
%            Number of atoms       :   86 (   1 equality)
%            Maximal formula depth :   13 (   7 average)
%            Number of connectives :   70 (   4 ~  ;   0  |;  10  &)
%                                         (   6 <=>;  50 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    7 (   1 constant; 0-2 arity)
%            Number of variables   :   50 (   0 singleton;  45 !;   5 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable relation_like_ : Universe -> Prop.
Variable EqCongruence_relation_like : forall x1 y1 : Universe, x1 = y1 -> relation_like_ x1 -> relation_like_ y1 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable EqCongruence_ilf_type : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ilf_type_ x1 x2 -> ilf_type_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .

Variable subset_type_ : Universe -> Universe.
Variable EqCongruence_subset_type : forall x1 y1 : Universe, x1 = y1 -> subset_type_ x1 = subset_type_ y1 .
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable EqCongruence_relation_type : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relation_type_ x1 x2 = relation_type_ y1 y2 .
Variable power_set_ : Universe -> Universe.
Variable EqCongruence_power_set : forall x1 y1 : Universe, x1 = y1 -> power_set_ x1 = power_set_ y1 .
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_ordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ordered_pair_ x1 x2 = ordered_pair_ y1 y2 .
Variable member_type_ : Universe -> Universe.
Variable EqCongruence_member_type : forall x1 y1 : Universe, x1 = y1 -> member_type_ x1 = member_type_ y1 .
Variable cross_product_ : Universe -> Universe -> Universe.
Variable EqCongruence_cross_product : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cross_product_ x1 x2 = cross_product_ y1 y2 .

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> ((subset_ B C /\ subset_ C D) -> subset_ B D))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> ((subset_ B C /\ subset_ D E) -> subset_ (cross_product_ B D) (cross_product_ C E)))))))))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p8_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p13_13 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p14_14 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p16_16 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p19_19 : (forall B : Universe, ilf_type_ B set_type_).

Set Firstorder Depth 10.

Theorem prove_relset_1_17_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> (forall F : Universe, (ilf_type_ F (relation_type_ B D) -> ((subset_ B C /\ subset_ D E) -> ilf_type_ F (relation_type_ C E)))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
