(*
% File     : SET637+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : Trybulec's 119th Boolean property of sets
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (119) [TS89] 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.25 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   2 unit)
%            Number of atoms       :   19 (   3 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   13 (   3 ~  ;   0  |;   2  &)
%                                         (   7 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   20 (   0 singleton;  19 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable not_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_not_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> not_equal_ x1 x2 -> not_equal_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable intersect_ : Universe -> Universe -> Prop.
Variable EqCongruence_intersect : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersect_ x1 x2 -> intersect_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .

Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable empty_set_ : Universe.

Variable intersection_defn_1 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable intersect_defn_2 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable empty_set_defn_3 : (forall B : Universe, ~(member_ B empty_set_)).
Variable equal_member_defn_4 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable not_equal_defn_5 : (forall B C : Universe, (not_equal_ B C <-> B <> C)).
Variable commutativity_of_intersection_6 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable symmetry_of_intersect_7 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable empty_defn_8 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Set Firstorder Depth 10.

Theorem prove_th119_9 : (forall B C : Universe, (intersect_ B C <-> not_equal_ (intersection_ B C) empty_set_)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
