(*
% File     : SET636+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X is disjoint from Y iff X ^ Y = the empty set
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : X is disjoint from Y iff the intersection of X and Y is the 
%            empty set.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (118) [TS89] 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   12 (   3 unit)
%            Number of atoms       :   26 (   4 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   17 (   3 ~  ;   0  |;   3  &)
%                                         (   9 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   26 (   0 singleton;  25 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable intersect_ : Universe -> Universe -> Prop.
Variable EqCongruence_intersect : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersect_ x1 x2 -> intersect_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .
Variable disjoint_ : Universe -> Universe -> Prop.
Variable EqCongruence_disjoint : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disjoint_ x1 x2 -> disjoint_ y1 y2 .

Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable empty_set_ : Universe.

Variable intersection_defn_1 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable intersect_defn_2 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable empty_set_defn_3 : (forall B : Universe, ~(member_ B empty_set_)).
Variable disjoint_defn_4 : (forall B C : Universe, (disjoint_ B C <-> ~(intersect_ B C))).
Variable equal_defn_5 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_intersection_6 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable symmetry_of_intersect_7 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable subset_defn_8 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_9 : (forall B : Universe, subset_ B B).
Variable empty_defn_10 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).
Variable equal_member_defn_11 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Set Firstorder Depth 10.

Theorem prove_th118_12 : (forall B C : Universe, (disjoint_ B C <-> (intersection_ B C) = empty_set_)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
