(*
% File     : SET633+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X \ Y (= Z and Y \ X (= Z, then X sym\ Y (= Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If the difference of X and Y is a subset of Z and the 
%            difference of Y and X is a subset of Z, then the symmetric 
%            difference of X and Y is a subset of Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (115) [TS89] 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.11 v2.7.0, 0.00 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   4 unit)
%            Number of atoms       :   19 (   4 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   11 (   1 ~  ;   0  |;   3  &)
%                                         (   4 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .

Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_symmetric_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> symmetric_difference_ x1 x2 = symmetric_difference_ y1 y2 .
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable symmetric_difference_defn_1 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable union_subset_2 : (forall B C D : Universe, ((subset_ B C /\ subset_ D C) -> subset_ (union_ B D) C)).
Variable difference_defn_3 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable subset_defn_4 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable commutativity_of_union_5 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_symmetric_difference_6 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_7 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable reflexivity_of_subset_8 : (forall B : Universe, subset_ B B).

Set Firstorder Depth 10.

Theorem prove_th115_9 : (forall B C D : Universe, ((subset_ (difference_ B C) D /\ subset_ (difference_ C B) D) -> subset_ (symmetric_difference_ B C) D)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
