(*
% File     : SET630+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X ^ Y is disjoint from X sym\ Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The intersection of X and Y is disjoint from the symmetric 
%            difference of X and Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (112) [TS89] 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.44 v2.7.0, 0.33 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 1.00 v1.0.0
% Syntax   : Number of formulae    :   12 (   6 unit)
%            Number of atoms       :   22 (   5 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   11 (   1 ~  ;   1  |;   2  &)
%                                         (   6 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 2-2 arity)
%            Number of functors    :    4 (   0 constant; 2-2 arity)
%            Number of variables   :   28 (   0 singleton;  27 !;   1 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable intersect_ : Universe -> Universe -> Prop.
Variable EqCongruence_intersect : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersect_ x1 x2 -> intersect_ y1 y2 .
Variable disjoint_ : Universe -> Universe -> Prop.
Variable EqCongruence_disjoint : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disjoint_ x1 x2 -> disjoint_ y1 y2 .

Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_symmetric_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> symmetric_difference_ x1 x2 = symmetric_difference_ y1 y2 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable symmetric_difference_defn_1 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable intersect_with_union_2 : (forall B C D : Universe, (intersect_ B (union_ C D) <-> (intersect_ B C \/ intersect_ B D))).
Variable intersection_and_union_disjoint_3 : (forall B C : Universe, disjoint_ (intersection_ B C) (difference_ B C)).
Variable intersection_defn_4 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable intersect_defn_5 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable disjoint_defn_6 : (forall B C : Universe, (disjoint_ B C <-> ~(intersect_ B C))).
Variable commutativity_of_union_7 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_8 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable commutativity_of_symmetric_difference_9 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable symmetry_of_intersect_10 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable equal_member_defn_11 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Set Firstorder Depth 10.

Theorem prove_intersection_and_symmetric_difference_disjoint_12 : (forall B C : Universe, disjoint_ (intersection_ B C) (symmetric_difference_ B C)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
