(*
% File     : SET629+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X ^ Y is disjoint from X \ Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The intersection of X and Y is disjoint from the difference of 
%            X and Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (111) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    8 (   2 unit)
%            Number of atoms       :   18 (   2 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   12 (   2 ~  ;   0  |;   3  &)
%                                         (   6 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 2-2 arity)
%            Number of functors    :    2 (   0 constant; 2-2 arity)
%            Number of variables   :   20 (   0 singleton;  19 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable intersect_ : Universe -> Universe -> Prop.
Variable EqCongruence_intersect : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersect_ x1 x2 -> intersect_ y1 y2 .
Variable disjoint_ : Universe -> Universe -> Prop.
Variable EqCongruence_disjoint : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disjoint_ x1 x2 -> disjoint_ y1 y2 .

Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable intersection_defn_1 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable difference_defn_2 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable intersect_defn_3 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable disjoint_defn_4 : (forall B C : Universe, (disjoint_ B C <-> ~(intersect_ B C))).
Variable commutativity_of_intersection_5 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable symmetry_of_intersect_6 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable equal_member_defn_7 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Set Firstorder Depth 10.

Theorem prove_intersection_and_difference_disjoint_8 : (forall B C : Universe, disjoint_ (intersection_ B C) (difference_ B C)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
