(*
% File     : SET625+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X intersects Y and Y is a subset of Z, then X intersects Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (101) [TS89] 
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    5 (   1 unit)
%            Number of atoms       :   12 (   0 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :    7 (   0 ~  ;   0  |;   2  &)
%                                         (   2 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   12 (   0 singleton;  11 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable intersect_ : Universe -> Universe -> Prop.


Variable intersect_defn_1 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable subset_defn_2 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable symmetry_of_intersect_3 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable reflexivity_of_subset_4 : (forall B : Universe, subset_ B B).

Set Firstorder Depth 10.

Theorem prove_th101_5 : (forall B C D : Universe, ((intersect_ B C /\ subset_ C D) -> intersect_ B D)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
