(*
% File     : SET616+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X \ Y = Y \ X, then X = Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If the difference of X and Y is the difference of Y and X, then 
%            X is Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (90) [TS89] 
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.33 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    7 (   1 unit)
%            Number of atoms       :   18 (   5 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   12 (   1 ~  ;   0  |;   2  &)
%                                         (   6 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   17 (   0 singleton;  17 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .

Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable member_equal_1 : (forall B C : Universe, ((forall D : Universe, (member_ D B <-> member_ D C)) -> B = C)).
Variable difference_defn_2 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_3 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable equal_member_defn_4 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_5 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_6 : (forall B : Universe, subset_ B B).

Set Firstorder Depth 10.

Theorem prove_th90_7 : (forall B C : Universe, ((difference_ B C) = (difference_ C B) -> B = C)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
