(*
% File     : SET602+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : The difference of X and X is the empty set
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (73) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    8 (   3 unit)
%            Number of atoms       :   16 (   3 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   11 (   3 ~  ;   0  |;   2  &)
%                                         (   5 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   15 (   0 singleton;  15 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .

Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable difference_empty_set_1 : (forall B C : Universe, ((difference_ B C) = empty_set_ <-> subset_ B C)).
Variable empty_set_defn_2 : (forall B : Universe, ~(member_ B empty_set_)).
Variable difference_defn_3 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_4 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable subset_defn_5 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_6 : (forall B : Universe, subset_ B B).
Variable empty_defn_7 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Set Firstorder Depth 10.

Theorem prove_self_difference_is_empty_set_8 : (forall B : Universe, (difference_ B B) = empty_set_).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
