(*
% File     : SET598+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X = Y ^ Z iff X (= Y, X (= Z, !V: V (= Y & V (= Z, V (= X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : X is the intersection of Y and Z if and only if the following 
%            conditions are satisfied: 1. X is a subset of Y, 2. X is a 
%            subset of Z, and 3. for every V such that V is a subset of Y 
%            and V is a subset of Z : V is a subset of X.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (57) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   3 unit)
%            Number of atoms       :   24 (   4 equality)
%            Maximal formula depth :   10 (   5 average)
%            Number of connectives :   15 (   0 ~  ;   0  |;   6  &)
%                                         (   6 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   23 (   0 singleton;  23 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .

Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .

Variable intersection_is_subset_1 : (forall B C : Universe, subset_ (intersection_ B C) B).
Variable intersection_of_subsets_2 : (forall B C D : Universe, ((subset_ B C /\ subset_ B D) -> subset_ B (intersection_ C D))).
Variable intersection_defn_3 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable subset_defn_4 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable equal_defn_5 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_intersection_6 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable reflexivity_of_subset_7 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_8 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Set Firstorder Depth 10.

Theorem prove_th57_9 : (forall B C D : Universe, (B = (intersection_ C D) <-> (subset_ B C /\ (subset_ B D /\ (forall E : Universe, ((subset_ E C /\ subset_ E D) -> subset_ E B)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
