(*
% File     : SET594+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X ^ Y U X ^ Z = X, then X (= Y U Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If the intersection of X and the union of Y and the 
%            intersection of X and Z is X, then X is a subset of the union 
%            of Y and Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (53) [TS89] 
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.33 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   3 unit)
%            Number of atoms       :   20 (   5 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :   11 (   0 ~  ;   1  |;   2  &)
%                                         (   6 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    2 (   0 constant; 2-2 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .

Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .

Variable subset_defn_1 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable union_defn_2 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable intersection_defn_3 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable equal_defn_4 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_5 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_6 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable reflexivity_of_subset_7 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_8 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Set Firstorder Depth 10.

Theorem prove_th53_9 : (forall B C D : Universe, ((union_ (intersection_ B C) (intersection_ B D)) = B -> subset_ B (union_ C D))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
