(*
% File     : SET585+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : The intersection of X and Y is a subset of the union of X and Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (38) [TS89] 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.50 v1.0.0
% Syntax   : Number of formulae    :   11 (   6 unit)
%            Number of atoms       :   21 (   3 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   10 (   0 ~  ;   1  |;   2  &)
%                                         (   5 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    2 (   0 constant; 2-2 arity)
%            Number of variables   :   27 (   0 singleton;  27 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .

Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .

Variable transitivity_of_subset_1 : (forall B C D : Universe, ((subset_ B C /\ subset_ C D) -> subset_ B D)).
Variable subset_of_union_2 : (forall B C : Universe, subset_ B (union_ B C)).
Variable intersection_is_subset_3 : (forall B C : Universe, subset_ (intersection_ B C) B).
Variable union_defn_4 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable intersection_defn_5 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable subset_defn_6 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable commutativity_of_union_7 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_8 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable reflexivity_of_subset_9 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_10 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Set Firstorder Depth 10.

Theorem prove_intersection_subset_of_union_11 : (forall B C D : Universe, subset_ (intersection_ B C) (union_ B D)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
