(*
% File     : SET583+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : Extensionality
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (28) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   1 unit)
%            Number of atoms       :   10 (   2 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    6 (   0 ~  ;   0  |;   2  &)
%                                         (   2 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    8 (   0 singleton;   8 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .


Variable equal_defn_1 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable subset_defn_2 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_3 : (forall B : Universe, subset_ B B).

Set Firstorder Depth 10.

Theorem prove_extensionality_4 : (forall B C : Universe, ((subset_ B C /\ subset_ C B) -> B = C)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
