(*
% File     : SET372+4 : ILTP v1.1.2
% Domain   : Set Theory (Naive)
% Problem  : Power set distributes over intersection
% Version  : [Pas99] axioms.
% English  : The power_set of the intersection of A and B is equal to the 
%            intersection of the power_set of A and the power_set of B.
% Refs     : [Pas99] Pastre (1999), Email to G. Sutcliffe
% Source   : [Pas99]
% Names    :
% Status   : Theorem
% Rating   : 0.91 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 0.86 v2.5.0, 0.88 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   12 (   2 unit)
%            Number of atoms       :   30 (   3 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   20 (   2 ~  ;   2  |;   4  &)
%                                         (  10 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 2-2 arity)
%            Number of functors    :    9 (   1 constant; 0-2 arity)
%            Number of variables   :   30 (   0 singleton;  29 !;   1 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable equal_set_ : Universe -> Universe -> Prop.
Variable EqCongruence_equal_set : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> equal_set_ x1 x2 -> equal_set_ y1 y2 .

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_unordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unordered_pair_ x1 x2 = unordered_pair_ y1 y2 .
Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable sum_ : Universe -> Universe.
Variable EqCongruence_sum : forall x1 y1 : Universe, x1 = y1 -> sum_ x1 = sum_ y1 .
Variable singleton_ : Universe -> Universe.
Variable EqCongruence_singleton : forall x1 y1 : Universe, x1 = y1 -> singleton_ x1 = singleton_ y1 .
Variable product_ : Universe -> Universe.
Variable EqCongruence_product : forall x1 y1 : Universe, x1 = y1 -> product_ x1 = product_ y1 .
Variable power_set_ : Universe -> Universe.
Variable EqCongruence_power_set : forall x1 y1 : Universe, x1 = y1 -> power_set_ x1 = power_set_ y1 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.
Variable EqCongruence_difference : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> difference_ x1 x2 = difference_ y1 y2 .

Variable subset_1 : (forall A B : Universe, (subset_ A B <-> (forall X : Universe, (member_ X A -> member_ X B)))).
Variable equal_set_2 : (forall A B : Universe, (equal_set_ A B <-> (subset_ A B /\ subset_ B A))).
Variable power_set_3 : (forall X A : Universe, (member_ X (power_set_ A) <-> subset_ X A)).
Variable intersection_4 : (forall X A B : Universe, (member_ X (intersection_ A B) <-> (member_ X A /\ member_ X B))).
Variable union_5 : (forall X A B : Universe, (member_ X (union_ A B) <-> (member_ X A \/ member_ X B))).
Variable empty_set_6 : (forall X : Universe, ~(member_ X empty_set_)).
Variable difference_7 : (forall B A E : Universe, (member_ B (difference_ E A) <-> (member_ B E /\ ~(member_ B A)))).
Variable singleton_8 : (forall X A : Universe, (member_ X (singleton_ A) <-> X = A)).
Variable unordered_pair_9 : (forall X A B : Universe, (member_ X (unordered_pair_ A B) <-> (X = A \/ X = B))).
Variable sum_10 : (forall X A : Universe, (member_ X (sum_ A) <-> (exists Y : Universe, (member_ Y A /\ member_ X Y)))).
Variable product_11 : (forall X A : Universe, (member_ X (product_ A) <-> (forall Y : Universe, (member_ Y A -> member_ X Y)))).

Set Firstorder Depth 10.

Theorem thI21_12 : (forall A B : Universe, equal_set_ (power_set_ (intersection_ A B)) (intersection_ (power_set_ A) (power_set_ B))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
