(*
% File     : SET063+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X is a subset of the empty set, then X is the empty set
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (30) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.00 v1.0.0
% Syntax   : Number of formulae    :    7 (   3 unit)
%            Number of atoms       :   13 (   2 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    8 (   2 ~  ;   0  |;   1  &)
%                                         (   3 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   11 (   0 singleton;  11 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subset_ : Universe -> Universe -> Prop.
Variable EqCongruence_subset : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subset_ x1 x2 -> subset_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable empty_ : Universe -> Prop.
Variable EqCongruence_empty : forall x1 y1 : Universe, x1 = y1 -> empty_ x1 -> empty_ y1 .

Variable empty_set_ : Universe.

Variable empty_set_subset_1 : (forall B : Universe, subset_ empty_set_ B).
Variable empty_set_defn_2 : (forall B : Universe, ~(member_ B empty_set_)).
Variable subset_defn_3 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable equal_defn_4 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable reflexivity_of_subset_5 : (forall B : Universe, subset_ B B).
Variable empty_defn_6 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Set Firstorder Depth 10.

Theorem prove_subset_of_empty_set_is_empty_set_7 : (forall B : Universe, (subset_ B empty_set_ -> B = empty_set_)).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
