(*
% File     : SET062+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : The empty set is a subset of X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (27) [TS89] 
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    5 (   3 unit)
%            Number of atoms       :    8 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    5 (   2 ~  ;   0  |;   0  &)
%                                         (   2 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :    8 (   0 singleton;   8 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable empty_set_ : Universe.

Variable empty_set_defn_1 : (forall B : Universe, ~(member_ B empty_set_)).
Variable subset_defn_2 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_3 : (forall B : Universe, subset_ B B).
Variable empty_defn_4 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Set Firstorder Depth 10.

Theorem prove_empty_set_subset_5 : (forall B : Universe, subset_ empty_set_ B).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
