(*
% File     : SET060+1 : ILTP v1.1.2
% Domain   : Set Theory
% Problem  : Nothing in the intersection of a set and its complement
% Version  : [Qua92] axioms : Reduced & Augmented > Complete.
% English  :
% Refs     : [Qua92] Quaife (1992), Automated Deduction in von Neumann-Bern
%          : [BL+86] Boyer et al. (1986), Set Theory in First-Order Logic:
% Source   : [Qua92]
% Names    :
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   42 (  17 unit)
%            Number of atoms       :   94 (  16 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   58 (   6 ~  ;   3  |;  23  &)
%                                         (  18 <=>;   8 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :   26 (   5 constant; 0-3 arity)
%            Number of variables   :   84 (   0 singleton;  80 !;   4 ?)
%            Maximal term depth    :    4 (   1 average)
% Comments :
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable subclass_ : Universe -> Universe -> Prop.
Variable EqCongruence_subclass : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> subclass_ x1 x2 -> subclass_ y1 y2 .
Variable member_ : Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> member_ x1 x2 -> member_ y1 y2 .
Variable inductive_ : Universe -> Prop.
Variable EqCongruence_inductive : forall x1 y1 : Universe, x1 = y1 -> inductive_ x1 -> inductive_ y1 .
Variable function_ : Universe -> Prop.
Variable EqCongruence_function : forall x1 y1 : Universe, x1 = y1 -> function_ x1 -> function_ y1 .
Variable disjoint_ : Universe -> Universe -> Prop.
Variable EqCongruence_disjoint : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> disjoint_ x1 x2 -> disjoint_ y1 y2 .

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_unordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unordered_pair_ x1 x2 = unordered_pair_ y1 y2 .
Variable universal_class_ : Universe.
Variable union_ : Universe -> Universe -> Universe.
Variable EqCongruence_union : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> union_ x1 x2 = union_ y1 y2 .
Variable sum_class_ : Universe -> Universe.
Variable EqCongruence_sum_class : forall x1 y1 : Universe, x1 = y1 -> sum_class_ x1 = sum_class_ y1 .
Variable successor_relation_ : Universe.
Variable successor_ : Universe -> Universe.
Variable EqCongruence_successor : forall x1 y1 : Universe, x1 = y1 -> successor_ x1 = successor_ y1 .
Variable singleton_ : Universe -> Universe.
Variable EqCongruence_singleton : forall x1 y1 : Universe, x1 = y1 -> singleton_ x1 = singleton_ y1 .
Variable second_ : Universe -> Universe.
Variable EqCongruence_second : forall x1 y1 : Universe, x1 = y1 -> second_ x1 = second_ y1 .
Variable rotate_ : Universe -> Universe.
Variable EqCongruence_rotate : forall x1 y1 : Universe, x1 = y1 -> rotate_ x1 = rotate_ y1 .
Variable restrict_ : Universe -> Universe -> Universe -> Universe.
Variable EqCongruence_restrict : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> restrict_ x1 x2 x3 = restrict_ y1 y2 y3 .
Variable range_of_ : Universe -> Universe.
Variable EqCongruence_range_of : forall x1 y1 : Universe, x1 = y1 -> range_of_ x1 = range_of_ y1 .
Variable power_class_ : Universe -> Universe.
Variable EqCongruence_power_class : forall x1 y1 : Universe, x1 = y1 -> power_class_ x1 = power_class_ y1 .
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable EqCongruence_ordered_pair : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> ordered_pair_ x1 x2 = ordered_pair_ y1 y2 .
Variable null_class_ : Universe.
Variable inverse_ : Universe -> Universe.
Variable EqCongruence_inverse : forall x1 y1 : Universe, x1 = y1 -> inverse_ x1 = inverse_ y1 .
Variable intersection_ : Universe -> Universe -> Universe.
Variable EqCongruence_intersection : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> intersection_ x1 x2 = intersection_ y1 y2 .
Variable image_ : Universe -> Universe -> Universe.
Variable EqCongruence_image : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> image_ x1 x2 = image_ y1 y2 .
Variable identity_relation_ : Universe.
Variable flip_ : Universe -> Universe.
Variable EqCongruence_flip : forall x1 y1 : Universe, x1 = y1 -> flip_ x1 = flip_ y1 .
Variable first_ : Universe -> Universe.
Variable EqCongruence_first : forall x1 y1 : Universe, x1 = y1 -> first_ x1 = first_ y1 .
Variable element_relation_ : Universe.
Variable domain_of_ : Universe -> Universe.
Variable EqCongruence_domain_of : forall x1 y1 : Universe, x1 = y1 -> domain_of_ x1 = domain_of_ y1 .
Variable cross_product_ : Universe -> Universe -> Universe.
Variable EqCongruence_cross_product : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cross_product_ x1 x2 = cross_product_ y1 y2 .
Variable compose_ : Universe -> Universe -> Universe.
Variable EqCongruence_compose : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> compose_ x1 x2 = compose_ y1 y2 .
Variable complement_ : Universe -> Universe.
Variable EqCongruence_complement : forall x1 y1 : Universe, x1 = y1 -> complement_ x1 = complement_ y1 .
Variable apply_ : Universe -> Universe -> Universe.
Variable EqCongruence_apply : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> apply_ x1 x2 = apply_ y1 y2 .

Variable subclass_defn_1 : (forall X Y : Universe, (subclass_ X Y <-> (forall U : Universe, (member_ U X -> member_ U Y)))).
Variable class_elements_are_sets_2 : (forall X : Universe, subclass_ X universal_class_).
Variable extensionality_3 : (forall X Y : Universe, (X = Y <-> (subclass_ X Y /\ subclass_ Y X))).
Variable unordered_pair_defn_4 : (forall U X Y : Universe, (member_ U (unordered_pair_ X Y) <-> (member_ U universal_class_ /\ (U = X \/ U = Y)))).
Variable unordered_pair_5 : (forall X Y : Universe, member_ (unordered_pair_ X Y) universal_class_).
Variable singleton_set_defn_6 : (forall X : Universe, (singleton_ X) = (unordered_pair_ X X)).
Variable ordered_pair_defn_7 : (forall X Y : Universe, (ordered_pair_ X Y) = (unordered_pair_ (singleton_ X) (unordered_pair_ X (singleton_ Y)))).
Variable cross_product_defn_8 : (forall U V X Y : Universe, (member_ (ordered_pair_ U V) (cross_product_ X Y) <-> (member_ U X /\ member_ V Y))).
Variable cross_product_9 : (forall X Y Z : Universe, (member_ Z (cross_product_ X Y) -> Z = (ordered_pair_ (first_ Z) (second_ Z)))).
Variable element_relation_defn_10 : (forall X Y : Universe, (member_ (ordered_pair_ X Y) element_relation_ <-> (member_ Y universal_class_ /\ member_ X Y))).
Variable element_relation_11 : subclass_ element_relation_ (cross_product_ universal_class_ universal_class_).
Variable intersection_12 : (forall X Y Z : Universe, (member_ Z (intersection_ X Y) <-> (member_ Z X /\ member_ Z Y))).
Variable complement_13 : (forall X Z : Universe, (member_ Z (complement_ X) <-> (member_ Z universal_class_ /\ ~(member_ Z X)))).
Variable restrict_defn_14 : (forall X XR Y : Universe, (restrict_ XR X Y) = (intersection_ XR (cross_product_ X Y))).
Variable null_class_defn_15 : (forall X : Universe, ~(member_ X null_class_)).
Variable domain_of_16 : (forall X Z : Universe, (member_ Z (domain_of_ X) <-> (member_ Z universal_class_ /\ (restrict_ X (singleton_ Z) universal_class_) <> null_class_))).
Variable rotate_defn_17 : (forall X U V W : Universe, (member_ (ordered_pair_ (ordered_pair_ U V) W) (rotate_ X) <-> (member_ (ordered_pair_ (ordered_pair_ U V) W) (cross_product_ (cross_product_ universal_class_ universal_class_) universal_class_) /\ member_ (ordered_pair_ (ordered_pair_ V W) U) X))).
Variable rotate_18 : (forall X : Universe, subclass_ (rotate_ X) (cross_product_ (cross_product_ universal_class_ universal_class_) universal_class_)).
Variable flip_defn_19 : (forall U V W X : Universe, (member_ (ordered_pair_ (ordered_pair_ U V) W) (flip_ X) <-> (member_ (ordered_pair_ (ordered_pair_ U V) W) (cross_product_ (cross_product_ universal_class_ universal_class_) universal_class_) /\ member_ (ordered_pair_ (ordered_pair_ V U) W) X))).
Variable flip_20 : (forall X : Universe, subclass_ (flip_ X) (cross_product_ (cross_product_ universal_class_ universal_class_) universal_class_)).
Variable union_defn_21 : (forall X Y Z : Universe, (member_ Z (union_ X Y) <-> (member_ Z X \/ member_ Z Y))).
Variable successor_defn_22 : (forall X : Universe, (successor_ X) = (union_ X (singleton_ X))).
Variable successor_relation_defn1_23 : subclass_ successor_relation_ (cross_product_ universal_class_ universal_class_).
Variable successor_relation_defn2_24 : (forall X Y : Universe, (member_ (ordered_pair_ X Y) successor_relation_ <-> (member_ X universal_class_ /\ (member_ Y universal_class_ /\ (successor_ X) = Y)))).
Variable inverse_defn_25 : (forall Y : Universe, (inverse_ Y) = (domain_of_ (flip_ (cross_product_ Y universal_class_)))).
Variable range_of_defn_26 : (forall Z : Universe, (range_of_ Z) = (domain_of_ (inverse_ Z))).
Variable image_defn_27 : (forall X XR : Universe, (image_ XR X) = (range_of_ (restrict_ XR X universal_class_))).
Variable inductive_defn_28 : (forall X : Universe, (inductive_ X <-> (member_ null_class_ X /\ subclass_ (image_ successor_relation_ X) X))).
Variable infinity_29 : (exists X : Universe, (member_ X universal_class_ /\ (inductive_ X /\ (forall Y : Universe, (inductive_ Y -> subclass_ X Y))))).
Variable sum_class_defn_30 : (forall U X : Universe, (member_ U (sum_class_ X) <-> (exists Y : Universe, (member_ U Y /\ member_ Y X)))).
Variable sum_class_31 : (forall X : Universe, (member_ X universal_class_ -> member_ (sum_class_ X) universal_class_)).
Variable power_class_defn_32 : (forall U X : Universe, (member_ U (power_class_ X) <-> (member_ U universal_class_ /\ subclass_ U X))).
Variable power_class_33 : (forall U : Universe, (member_ U universal_class_ -> member_ (power_class_ U) universal_class_)).
Variable compose_defn1_34 : (forall XR YR : Universe, subclass_ (compose_ YR XR) (cross_product_ universal_class_ universal_class_)).
Variable compose_defn2_35 : (forall XR YR U V : Universe, (member_ (ordered_pair_ U V) (compose_ YR XR) <-> (member_ U universal_class_ /\ member_ V (image_ YR (image_ YR (singleton_ U)))))).
Variable function_defn_36 : (forall XF : Universe, (function_ XF <-> (subclass_ XF (cross_product_ universal_class_ universal_class_) /\ subclass_ (compose_ XF (inverse_ XF)) identity_relation_))).
Variable replacement_37 : (forall X XF : Universe, ((member_ X universal_class_ /\ function_ XF) -> member_ (image_ XF X) universal_class_)).
Variable disjoint_defn_38 : (forall X Y : Universe, (disjoint_ X Y <-> (forall U : Universe, ~((member_ U X /\ member_ U Y))))).
Variable regularity_39 : (forall X : Universe, (X <> null_class_ -> (exists U : Universe, (member_ U universal_class_ /\ (member_ U X /\ disjoint_ U X))))).
Variable apply_defn_40 : (forall XF Y : Universe, (apply_ XF Y) = (sum_class_ (image_ XF (singleton_ Y)))).
Variable choice_41 : (exists XF : Universe, (function_ XF /\ (forall Y : Universe, (member_ Y universal_class_ -> (Y = null_class_ \/ member_ (apply_ XF Y) Y))))).

Set Firstorder Depth 10.

Theorem special_classes_lemma_42 : (forall X Y : Universe, ~(member_ Y (intersection_ (complement_ X) X))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
