(*
% File     : SET046+1 : ILTP v1.1.2
% Domain   : Set Theory
% Problem  : No set of non-circular sets
% Version  : Especial.
% English  : A set is circular if it is a member of another set which 
%            in turn is a member of the orginal. Intuitively all sets are 
%            non-circular. Prove there is no set of non-circular sets.
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 42 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :    3 (   0 equality)
%            Maximal formula depth :    8 (   8 average)
%            Number of connectives :    4 (   2 ~  ;   0  |;   1  &)
%                                         (   1 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    3 (   0 singleton;   1 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable element_ : Universe -> Universe -> Prop.



Set Firstorder Depth 10.

Theorem pel42_1 : ~((exists Y : Universe, (forall X : Universe, (element_ X Y <-> ~((exists Z : Universe, (element_ X Z /\ element_ Z X))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
