(*
% File     : PUZ031+1 : ILTP v1.1.2
% Domain   : Puzzles
% Problem  : Schubert's Steamroller
% Version  : Especial.
% English  : Wolves, foxes, birds, caterpillars, and snails are animals, and
%            there are some of each of them. Also there are some grains, and
%            grains are plants. Every animal either likes to eat all plants
%            or all animals much smaller than itself that like to eat some
%            plants. Caterpillars and snails are much smaller than birds,
%            which are much smaller than foxes, which in turn are much
%            smaller than wolves. Wolves do not like to eat foxes or grains,
%            while birds like to eat caterpillars but not snails.
%            Caterpillars and snails like to eat some plants. Therefore
%            there is an animal that likes to eat a grain eating animal.
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 47 [Pel86]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   21 (   6 unit)
%            Number of atoms       :   55 (   0 equality)
%            Maximal formula depth :   10 (   4 average)
%            Number of connectives :   36 (   2 ~  ;   4  |;  14  &)
%                                         (   0 <=>;  16 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   33 (   0 singleton;  22 !;  11 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : This problem is named after Len Schubert.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable wolf_ : Universe -> Prop.
Variable snail_ : Universe -> Prop.
Variable plant_ : Universe -> Prop.
Variable much_smaller_ : Universe -> Universe -> Prop.
Variable grain_ : Universe -> Prop.
Variable fox_ : Universe -> Prop.
Variable eats_ : Universe -> Universe -> Prop.
Variable caterpillar_ : Universe -> Prop.
Variable bird_ : Universe -> Prop.
Variable animal_ : Universe -> Prop.


Variable pel47_1_1_1 : (forall X : Universe, (wolf_ X -> animal_ X)).
Variable pel47_1_2_2 : (exists X1 : Universe, wolf_ X1).
Variable pel47_2_1_3 : (forall X : Universe, (fox_ X -> animal_ X)).
Variable pel47_2_2_4 : (exists X1 : Universe, fox_ X1).
Variable pel47_3_1_5 : (forall X : Universe, (bird_ X -> animal_ X)).
Variable pel47_3_2_6 : (exists X1 : Universe, bird_ X1).
Variable pel47_4_1_7 : (forall X : Universe, (caterpillar_ X -> animal_ X)).
Variable pel47_4_2_8 : (exists X1 : Universe, caterpillar_ X1).
Variable pel47_5_1_9 : (forall X : Universe, (snail_ X -> animal_ X)).
Variable pel47_5_2_10 : (exists X1 : Universe, snail_ X1).
Variable pel47_6_1_11 : (exists X : Universe, grain_ X).
Variable pel47_6_2_12 : (forall X1 : Universe, (grain_ X1 -> plant_ X1)).
Variable pel47_7_13 : (forall X : Universe, (animal_ X -> ((forall Y : Universe, (plant_ Y -> eats_ X Y)) \/ (forall Y1 : Universe, ((animal_ Y1 /\ (much_smaller_ Y1 X /\ (exists Z : Universe, (plant_ Z /\ eats_ Y1 Z)))) -> eats_ X Y1))))).
Variable pel47_8_14 : (forall X Y : Universe, ((bird_ Y /\ (snail_ X \/ caterpillar_ X)) -> much_smaller_ X Y)).
Variable pel47_9_15 : (forall X Y : Universe, ((bird_ X /\ fox_ Y) -> much_smaller_ X Y)).
Variable pel47_10_16 : (forall X Y : Universe, ((fox_ X /\ wolf_ Y) -> much_smaller_ X Y)).
Variable pel47_11_17 : (forall X Y : Universe, ((wolf_ X /\ (fox_ Y \/ grain_ Y)) -> ~(eats_ X Y))).
Variable pel47_12_18 : (forall X Y : Universe, ((bird_ X /\ caterpillar_ Y) -> eats_ X Y)).
Variable pel47_13_19 : (forall X Y : Universe, ((bird_ X /\ snail_ Y) -> ~(eats_ X Y))).
Variable pel47_14_20 : (forall X : Universe, ((caterpillar_ X \/ snail_ X) -> (exists Y : Universe, (plant_ Y /\ eats_ X Y)))).

Set Firstorder Depth 10.

Theorem pel47_21 : (exists X Y : Universe, (animal_ X /\ (animal_ Y /\ (exists Z : Universe, (grain_ Z /\ (eats_ Y Z /\ eats_ X Y)))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
