(*
% File     : NLP205+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : An old dirty white Chevy, problem 92
% Version  : [Bos00b] axioms.
% English  : Eliminating inconsistent interpretations in the statement
%            An old dirty white chevy barrels down a lonely street in 
%            hollywood. Two young fellas are in the front seat. They are 
%            wearing cheap black coats. Jules is behind the wheel.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris182 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.25 v3.1.0, 0.33 v2.7.0, 0.50 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   72 (   1 unit)
%            Number of atoms       :  204 (   7 equality)
%            Maximal formula depth :   52 (   5 average)
%            Number of connectives :  149 (  17 ~  ;   1  |;  55  &)
%                                         (   1 <=>;  75 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   72 (   0 propositional; 1-4 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :  173 (   0 singleton; 153 !;  20 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable young_ : Universe -> Universe -> Prop.
Variable EqCongruence_young : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> young_ x1 x2 -> young_ y1 y2 .
Variable white_ : Universe -> Universe -> Prop.
Variable EqCongruence_white : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> white_ x1 x2 -> white_ y1 y2 .
Variable wheel_ : Universe -> Universe -> Prop.
Variable EqCongruence_wheel : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> wheel_ x1 x2 -> wheel_ y1 y2 .
Variable wear_ : Universe -> Universe -> Prop.
Variable EqCongruence_wear : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> wear_ x1 x2 -> wear_ y1 y2 .
Variable way_ : Universe -> Universe -> Prop.
Variable EqCongruence_way : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> way_ x1 x2 -> way_ y1 y2 .
Variable vehicle_ : Universe -> Universe -> Prop.
Variable EqCongruence_vehicle : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> vehicle_ x1 x2 -> vehicle_ y1 y2 .
Variable unisex_ : Universe -> Universe -> Prop.
Variable EqCongruence_unisex : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unisex_ x1 x2 -> unisex_ y1 y2 .
Variable two_ : Universe -> Universe -> Prop.
Variable EqCongruence_two : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> two_ x1 x2 -> two_ y1 y2 .
Variable transport_ : Universe -> Universe -> Prop.
Variable EqCongruence_transport : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> transport_ x1 x2 -> transport_ y1 y2 .
Variable thing_ : Universe -> Universe -> Prop.
Variable EqCongruence_thing : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> thing_ x1 x2 -> thing_ y1 y2 .
Variable street_ : Universe -> Universe -> Prop.
Variable EqCongruence_street : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> street_ x1 x2 -> street_ y1 y2 .
Variable state_ : Universe -> Universe -> Prop.
Variable EqCongruence_state : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> state_ x1 x2 -> state_ y1 y2 .
Variable specific_ : Universe -> Universe -> Prop.
Variable EqCongruence_specific : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> specific_ x1 x2 -> specific_ y1 y2 .
Variable singleton_ : Universe -> Universe -> Prop.
Variable EqCongruence_singleton : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> singleton_ x1 x2 -> singleton_ y1 y2 .
Variable set_ : Universe -> Universe -> Prop.
Variable EqCongruence_set : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> set_ x1 x2 -> set_ y1 y2 .
Variable seat_ : Universe -> Universe -> Prop.
Variable EqCongruence_seat : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> seat_ x1 x2 -> seat_ y1 y2 .
Variable relname_ : Universe -> Universe -> Prop.
Variable EqCongruence_relname : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relname_ x1 x2 -> relname_ y1 y2 .
Variable relation_ : Universe -> Universe -> Prop.
Variable EqCongruence_relation : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relation_ x1 x2 -> relation_ y1 y2 .
Variable present_ : Universe -> Universe -> Prop.
Variable EqCongruence_present : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> present_ x1 x2 -> present_ y1 y2 .
Variable placename_ : Universe -> Universe -> Prop.
Variable EqCongruence_placename : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> placename_ x1 x2 -> placename_ y1 y2 .
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_patient : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> patient_ x1 x2 x3 -> patient_ y1 y2 y3 .
Variable organism_ : Universe -> Universe -> Prop.
Variable EqCongruence_organism : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> organism_ x1 x2 -> organism_ y1 y2 .
Variable old_ : Universe -> Universe -> Prop.
Variable EqCongruence_old : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> old_ x1 x2 -> old_ y1 y2 .
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_of : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> of_ x1 x2 x3 -> of_ y1 y2 y3 .
Variable object_ : Universe -> Universe -> Prop.
Variable EqCongruence_object : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> object_ x1 x2 -> object_ y1 y2 .
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonreflexive : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonreflexive_ x1 x2 -> nonreflexive_ y1 y2 .
Variable nonliving_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonliving : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonliving_ x1 x2 -> nonliving_ y1 y2 .
Variable nonhuman_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonhuman : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonhuman_ x1 x2 -> nonhuman_ y1 y2 .
Variable nonexistent_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonexistent : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonexistent_ x1 x2 -> nonexistent_ y1 y2 .
Variable multiple_ : Universe -> Universe -> Prop.
Variable EqCongruence_multiple : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> multiple_ x1 x2 -> multiple_ y1 y2 .
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_member : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> member_ x1 x2 x3 -> member_ y1 y2 y3 .
Variable man_ : Universe -> Universe -> Prop.
Variable EqCongruence_man : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> man_ x1 x2 -> man_ y1 y2 .
Variable male_ : Universe -> Universe -> Prop.
Variable EqCongruence_male : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> male_ x1 x2 -> male_ y1 y2 .
Variable lonely_ : Universe -> Universe -> Prop.
Variable EqCongruence_lonely : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> lonely_ x1 x2 -> lonely_ y1 y2 .
Variable location_ : Universe -> Universe -> Prop.
Variable EqCongruence_location : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> location_ x1 x2 -> location_ y1 y2 .
Variable living_ : Universe -> Universe -> Prop.
Variable EqCongruence_living : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> living_ x1 x2 -> living_ y1 y2 .
Variable jules_forename_ : Universe -> Universe -> Prop.
Variable EqCongruence_jules_forename : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> jules_forename_ x1 x2 -> jules_forename_ y1 y2 .
Variable instrumentality_ : Universe -> Universe -> Prop.
Variable EqCongruence_instrumentality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> instrumentality_ x1 x2 -> instrumentality_ y1 y2 .
Variable in_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_in : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> in_ x1 x2 x3 -> in_ y1 y2 y3 .
Variable impartial_ : Universe -> Universe -> Prop.
Variable EqCongruence_impartial : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> impartial_ x1 x2 -> impartial_ y1 y2 .
Variable human_person_ : Universe -> Universe -> Prop.
Variable EqCongruence_human_person : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> human_person_ x1 x2 -> human_person_ y1 y2 .
Variable human_ : Universe -> Universe -> Prop.
Variable EqCongruence_human : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> human_ x1 x2 -> human_ y1 y2 .
Variable hollywood_placename_ : Universe -> Universe -> Prop.
Variable EqCongruence_hollywood_placename : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hollywood_placename_ x1 x2 -> hollywood_placename_ y1 y2 .
Variable group_ : Universe -> Universe -> Prop.
Variable EqCongruence_group : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> group_ x1 x2 -> group_ y1 y2 .
Variable general_ : Universe -> Universe -> Prop.
Variable EqCongruence_general : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> general_ x1 x2 -> general_ y1 y2 .
Variable furniture_ : Universe -> Universe -> Prop.
Variable EqCongruence_furniture : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> furniture_ x1 x2 -> furniture_ y1 y2 .
Variable frontseat_ : Universe -> Universe -> Prop.
Variable EqCongruence_frontseat : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> frontseat_ x1 x2 -> frontseat_ y1 y2 .
Variable forename_ : Universe -> Universe -> Prop.
Variable EqCongruence_forename : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> forename_ x1 x2 -> forename_ y1 y2 .
Variable fellow_ : Universe -> Universe -> Prop.
Variable EqCongruence_fellow : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> fellow_ x1 x2 -> fellow_ y1 y2 .
Variable existent_ : Universe -> Universe -> Prop.
Variable EqCongruence_existent : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> existent_ x1 x2 -> existent_ y1 y2 .
Variable eventuality_ : Universe -> Universe -> Prop.
Variable EqCongruence_eventuality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> eventuality_ x1 x2 -> eventuality_ y1 y2 .
Variable event_ : Universe -> Universe -> Prop.
Variable EqCongruence_event : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> event_ x1 x2 -> event_ y1 y2 .
Variable entity_ : Universe -> Universe -> Prop.
Variable EqCongruence_entity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> entity_ x1 x2 -> entity_ y1 y2 .
Variable down_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_down : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> down_ x1 x2 x3 -> down_ y1 y2 y3 .
Variable dirty_ : Universe -> Universe -> Prop.
Variable EqCongruence_dirty : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> dirty_ x1 x2 -> dirty_ y1 y2 .
Variable device_ : Universe -> Universe -> Prop.
Variable EqCongruence_device : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> device_ x1 x2 -> device_ y1 y2 .
Variable coat_ : Universe -> Universe -> Prop.
Variable EqCongruence_coat : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> coat_ x1 x2 -> coat_ y1 y2 .
Variable clothes_ : Universe -> Universe -> Prop.
Variable EqCongruence_clothes : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> clothes_ x1 x2 -> clothes_ y1 y2 .
Variable city_ : Universe -> Universe -> Prop.
Variable EqCongruence_city : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> city_ x1 x2 -> city_ y1 y2 .
Variable chevy_ : Universe -> Universe -> Prop.
Variable EqCongruence_chevy : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> chevy_ x1 x2 -> chevy_ y1 y2 .
Variable cheap_ : Universe -> Universe -> Prop.
Variable EqCongruence_cheap : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> cheap_ x1 x2 -> cheap_ y1 y2 .
Variable car_ : Universe -> Universe -> Prop.
Variable EqCongruence_car : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> car_ x1 x2 -> car_ y1 y2 .
Variable black_ : Universe -> Universe -> Prop.
Variable EqCongruence_black : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> black_ x1 x2 -> black_ y1 y2 .
Variable behind_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_behind : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> behind_ x1 x2 x3 -> behind_ y1 y2 y3 .
Variable be_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_be : forall x1 x2 x3 x4 y1 y2 y3 y4 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> x4 = y4 -> be_ x1 x2 x3 x4 -> be_ y1 y2 y3 y4 .
Variable barrel_ : Universe -> Universe -> Prop.
Variable EqCongruence_barrel : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> barrel_ x1 x2 -> barrel_ y1 y2 .
Variable artifact_ : Universe -> Universe -> Prop.
Variable EqCongruence_artifact : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> artifact_ x1 x2 -> artifact_ y1 y2 .
Variable animate_ : Universe -> Universe -> Prop.
Variable EqCongruence_animate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> animate_ x1 x2 -> animate_ y1 y2 .
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_agent : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> agent_ x1 x2 x3 -> agent_ y1 y2 y3 .
Variable actual_world_ : Universe -> Prop.
Variable EqCongruence_actual_world : forall x1 y1 : Universe, x1 = y1 -> actual_world_ x1 -> actual_world_ y1 .
Variable abstraction_ : Universe -> Universe -> Prop.
Variable EqCongruence_abstraction : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> abstraction_ x1 x2 -> abstraction_ y1 y2 .


Variable ax1_1 : (forall U V : Universe, (jules_forename_ U V -> forename_ U V)).
Variable ax2_2 : (forall U V : Universe, (forename_ U V -> relname_ U V)).
Variable ax3_3 : (forall U V : Universe, (furniture_ U V -> instrumentality_ U V)).
Variable ax4_4 : (forall U V : Universe, (seat_ U V -> furniture_ U V)).
Variable ax5_5 : (forall U V : Universe, (frontseat_ U V -> seat_ U V)).
Variable ax6_6 : (forall U V : Universe, (location_ U V -> object_ U V)).
Variable ax7_7 : (forall U V : Universe, (city_ U V -> location_ U V)).
Variable ax8_8 : (forall U V : Universe, (hollywood_placename_ U V -> placename_ U V)).
Variable ax9_9 : (forall U V : Universe, (abstraction_ U V -> unisex_ U V)).
Variable ax10_10 : (forall U V : Universe, (abstraction_ U V -> general_ U V)).
Variable ax11_11 : (forall U V : Universe, (abstraction_ U V -> nonhuman_ U V)).
Variable ax12_12 : (forall U V : Universe, (abstraction_ U V -> thing_ U V)).
Variable ax13_13 : (forall U V : Universe, (relation_ U V -> abstraction_ U V)).
Variable ax14_14 : (forall U V : Universe, (relname_ U V -> relation_ U V)).
Variable ax15_15 : (forall U V : Universe, (placename_ U V -> relname_ U V)).
Variable ax16_16 : (forall U V : Universe, (transport_ U V -> instrumentality_ U V)).
Variable ax17_17 : (forall U V : Universe, (vehicle_ U V -> transport_ U V)).
Variable ax18_18 : (forall U V : Universe, (car_ U V -> vehicle_ U V)).
Variable ax19_19 : (forall U V : Universe, (chevy_ U V -> car_ U V)).
Variable ax20_20 : (forall U V : Universe, (way_ U V -> artifact_ U V)).
Variable ax21_21 : (forall U V : Universe, (street_ U V -> way_ U V)).
Variable ax22_22 : (forall U V : Universe, (barrel_ U V -> event_ U V)).
Variable ax23_23 : (forall U V : Universe, (two_ U V -> group_ U V)).
Variable ax24_24 : (forall U V : Universe, (man_ U V -> male_ U V)).
Variable ax25_25 : (forall U V : Universe, (human_person_ U V -> animate_ U V)).
Variable ax26_26 : (forall U V : Universe, (human_person_ U V -> human_ U V)).
Variable ax27_27 : (forall U V : Universe, (organism_ U V -> living_ U V)).
Variable ax28_28 : (forall U V : Universe, (organism_ U V -> impartial_ U V)).
Variable ax29_29 : (forall U V : Universe, (organism_ U V -> entity_ U V)).
Variable ax30_30 : (forall U V : Universe, (human_person_ U V -> organism_ U V)).
Variable ax31_31 : (forall U V : Universe, (man_ U V -> human_person_ U V)).
Variable ax32_32 : (forall U V : Universe, (fellow_ U V -> man_ U V)).
Variable ax33_33 : (forall U V : Universe, (wear_ U V -> event_ U V)).
Variable ax34_34 : (forall U V : Universe, (set_ U V -> multiple_ U V)).
Variable ax35_35 : (forall U V : Universe, (group_ U V -> set_ U V)).
Variable ax36_36 : (forall U V : Universe, (clothes_ U V -> artifact_ U V)).
Variable ax37_37 : (forall U V : Universe, (coat_ U V -> clothes_ U V)).
Variable ax38_38 : (forall U V : Universe, (object_ U V -> unisex_ U V)).
Variable ax39_39 : (forall U V : Universe, (object_ U V -> impartial_ U V)).
Variable ax40_40 : (forall U V : Universe, (object_ U V -> nonliving_ U V)).
Variable ax41_41 : (forall U V : Universe, (entity_ U V -> existent_ U V)).
Variable ax42_42 : (forall U V : Universe, (entity_ U V -> specific_ U V)).
Variable ax43_43 : (forall U V : Universe, (entity_ U V -> thing_ U V)).
Variable ax44_44 : (forall U V : Universe, (object_ U V -> entity_ U V)).
Variable ax45_45 : (forall U V : Universe, (artifact_ U V -> object_ U V)).
Variable ax46_46 : (forall U V : Universe, (instrumentality_ U V -> artifact_ U V)).
Variable ax47_47 : (forall U V : Universe, (device_ U V -> instrumentality_ U V)).
Variable ax48_48 : (forall U V : Universe, (wheel_ U V -> device_ U V)).
Variable ax49_49 : (forall U V : Universe, (event_ U V -> eventuality_ U V)).
Variable ax50_50 : (forall U V : Universe, (state_ U V -> event_ U V)).
Variable ax51_51 : (forall U V : Universe, (eventuality_ U V -> unisex_ U V)).
Variable ax52_52 : (forall U V : Universe, (eventuality_ U V -> nonexistent_ U V)).
Variable ax53_53 : (forall U V : Universe, (eventuality_ U V -> specific_ U V)).
Variable ax54_54 : (forall U V : Universe, (thing_ U V -> singleton_ U V)).
Variable ax55_55 : (forall U V : Universe, (eventuality_ U V -> thing_ U V)).
Variable ax56_56 : (forall U V : Universe, (state_ U V -> eventuality_ U V)).
Variable ax57_57 : (forall U V : Universe, (animate_ U V -> ~(nonliving_ U V))).
Variable ax58_58 : (forall U V : Universe, (existent_ U V -> ~(nonexistent_ U V))).
Variable ax59_59 : (forall U V : Universe, (nonhuman_ U V -> ~(human_ U V))).
Variable ax60_60 : (forall U V : Universe, (nonliving_ U V -> ~(living_ U V))).
Variable ax61_61 : (forall U V : Universe, (singleton_ U V -> ~(multiple_ U V))).
Variable ax62_62 : (forall U V : Universe, (specific_ U V -> ~(general_ U V))).
Variable ax63_63 : (forall U V : Universe, (unisex_ U V -> ~(male_ U V))).
Variable ax64_64 : (forall U V : Universe, (white_ U V -> ~(black_ U V))).
Variable ax65_65 : (forall U V : Universe, (young_ U V -> ~(old_ U V))).
Variable ax66_66 : (forall U V W : Universe, ((entity_ U V /\ (forename_ U W /\ of_ U W V)) -> ~((exists X : Universe, (forename_ U X /\ (X <> W /\ of_ U X V)))))).
Variable ax67_67 : (forall U V W : Universe, ((entity_ U V /\ (placename_ U W /\ of_ U W V)) -> ~((exists X : Universe, (placename_ U X /\ (X <> W /\ of_ U X V)))))).
Variable ax68_68 : (forall U V : Universe, (two_ U V <-> (exists W : Universe, (member_ U W V /\ (exists X : Universe, (member_ U X V /\ (X <> W /\ (forall Y : Universe, (member_ U Y V -> (Y = X \/ Y = W)))))))))).
Variable ax69_69 : (forall U V W X : Universe, ((nonreflexive_ U V /\ (agent_ U V W /\ patient_ U V X)) -> W <> X)).
Variable ax70_70 : (forall U : Universe, ~((exists V : Universe, member_ U V V))).
Variable ax71_71 : (forall U V W X : Universe, (be_ U V W X -> W = X)).

Set Firstorder Depth 10.

Theorem co1_72 : ~((exists U : Universe, (actual_world_ U /\ (exists V W X Y Z X1 X2 X3 X4 X5 X6 : Universe, (of_ U W V /\ (man_ U V /\ (jules_forename_ U W /\ (forename_ U W /\ (wheel_ U X /\ (frontseat_ U X1 /\ (chevy_ U Y /\ (white_ U Y /\ (dirty_ U Y /\ (old_ U Y /\ (of_ U Z X1 /\ (city_ U X1 /\ (hollywood_placename_ U Z /\ (placename_ U Z /\ (street_ U X1 /\ (lonely_ U X1 /\ (event_ U X2 /\ (agent_ U X2 Y /\ (present_ U X2 /\ (barrel_ U X2 /\ (down_ U X2 X1 /\ (in_ U X2 X1 /\ ((forall X7 : Universe, (member_ U X7 X3 -> (exists X8 X9 : Universe, (state_ U X8 /\ (be_ U X8 X7 X9 /\ in_ U X9 X1))))) /\ (two_ U X3 /\ (group_ U X3 /\ ((forall X10 : Universe, (member_ U X10 X3 -> (fellow_ U X10 /\ young_ U X10))) /\ ((forall X11 : Universe, (member_ U X11 X4 -> (forall X12 : Universe, (member_ U X12 X3 -> (exists X13 : Universe, (event_ U X13 /\ (agent_ U X13 X12 /\ (patient_ U X13 X11 /\ (present_ U X13 /\ (nonreflexive_ U X13 /\ wear_ U X13)))))))))) /\ (group_ U X4 /\ ((forall X14 : Universe, (member_ U X14 X4 -> (coat_ U X14 /\ (black_ U X14 /\ cheap_ U X14)))) /\ (state_ U X5 /\ (be_ U X5 V X6 /\ behind_ U X6 X))))))))))))))))))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
