(*
% File     : NLP125+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : An old dirty white Chevy, problem 12
% Version  : [Bos00b] axioms.
% English  : Eliminating inconsistent interpretations in the statement
%            An old dirty white chevy barrels down a lonely street in 
%            hollywood.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris102 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   36 (   0 unit)
%            Number of atoms       :   91 (   1 equality)
%            Maximal formula depth :   23 (   5 average)
%            Number of connectives :   60 (   5 ~  ;   0  |;  20  &)
%                                         (   0 <=>;  35 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   41 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   77 (   0 singleton;  71 !;   6 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable white_ : Universe -> Universe -> Prop.
Variable EqCongruence_white : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> white_ x1 x2 -> white_ y1 y2 .
Variable way_ : Universe -> Universe -> Prop.
Variable EqCongruence_way : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> way_ x1 x2 -> way_ y1 y2 .
Variable vehicle_ : Universe -> Universe -> Prop.
Variable EqCongruence_vehicle : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> vehicle_ x1 x2 -> vehicle_ y1 y2 .
Variable unisex_ : Universe -> Universe -> Prop.
Variable EqCongruence_unisex : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unisex_ x1 x2 -> unisex_ y1 y2 .
Variable transport_ : Universe -> Universe -> Prop.
Variable EqCongruence_transport : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> transport_ x1 x2 -> transport_ y1 y2 .
Variable thing_ : Universe -> Universe -> Prop.
Variable EqCongruence_thing : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> thing_ x1 x2 -> thing_ y1 y2 .
Variable street_ : Universe -> Universe -> Prop.
Variable EqCongruence_street : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> street_ x1 x2 -> street_ y1 y2 .
Variable specific_ : Universe -> Universe -> Prop.
Variable EqCongruence_specific : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> specific_ x1 x2 -> specific_ y1 y2 .
Variable singleton_ : Universe -> Universe -> Prop.
Variable EqCongruence_singleton : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> singleton_ x1 x2 -> singleton_ y1 y2 .
Variable relname_ : Universe -> Universe -> Prop.
Variable EqCongruence_relname : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relname_ x1 x2 -> relname_ y1 y2 .
Variable relation_ : Universe -> Universe -> Prop.
Variable EqCongruence_relation : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> relation_ x1 x2 -> relation_ y1 y2 .
Variable present_ : Universe -> Universe -> Prop.
Variable EqCongruence_present : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> present_ x1 x2 -> present_ y1 y2 .
Variable placename_ : Universe -> Universe -> Prop.
Variable EqCongruence_placename : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> placename_ x1 x2 -> placename_ y1 y2 .
Variable old_ : Universe -> Universe -> Prop.
Variable EqCongruence_old : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> old_ x1 x2 -> old_ y1 y2 .
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_of : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> of_ x1 x2 x3 -> of_ y1 y2 y3 .
Variable object_ : Universe -> Universe -> Prop.
Variable EqCongruence_object : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> object_ x1 x2 -> object_ y1 y2 .
Variable nonliving_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonliving : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonliving_ x1 x2 -> nonliving_ y1 y2 .
Variable nonhuman_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonhuman : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonhuman_ x1 x2 -> nonhuman_ y1 y2 .
Variable nonexistent_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonexistent : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonexistent_ x1 x2 -> nonexistent_ y1 y2 .
Variable lonely_ : Universe -> Universe -> Prop.
Variable EqCongruence_lonely : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> lonely_ x1 x2 -> lonely_ y1 y2 .
Variable location_ : Universe -> Universe -> Prop.
Variable EqCongruence_location : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> location_ x1 x2 -> location_ y1 y2 .
Variable instrumentality_ : Universe -> Universe -> Prop.
Variable EqCongruence_instrumentality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> instrumentality_ x1 x2 -> instrumentality_ y1 y2 .
Variable in_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_in : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> in_ x1 x2 x3 -> in_ y1 y2 y3 .
Variable impartial_ : Universe -> Universe -> Prop.
Variable EqCongruence_impartial : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> impartial_ x1 x2 -> impartial_ y1 y2 .
Variable hollywood_placename_ : Universe -> Universe -> Prop.
Variable EqCongruence_hollywood_placename : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hollywood_placename_ x1 x2 -> hollywood_placename_ y1 y2 .
Variable general_ : Universe -> Universe -> Prop.
Variable EqCongruence_general : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> general_ x1 x2 -> general_ y1 y2 .
Variable existent_ : Universe -> Universe -> Prop.
Variable EqCongruence_existent : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> existent_ x1 x2 -> existent_ y1 y2 .
Variable eventuality_ : Universe -> Universe -> Prop.
Variable EqCongruence_eventuality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> eventuality_ x1 x2 -> eventuality_ y1 y2 .
Variable event_ : Universe -> Universe -> Prop.
Variable EqCongruence_event : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> event_ x1 x2 -> event_ y1 y2 .
Variable entity_ : Universe -> Universe -> Prop.
Variable EqCongruence_entity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> entity_ x1 x2 -> entity_ y1 y2 .
Variable down_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_down : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> down_ x1 x2 x3 -> down_ y1 y2 y3 .
Variable dirty_ : Universe -> Universe -> Prop.
Variable EqCongruence_dirty : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> dirty_ x1 x2 -> dirty_ y1 y2 .
Variable city_ : Universe -> Universe -> Prop.
Variable EqCongruence_city : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> city_ x1 x2 -> city_ y1 y2 .
Variable chevy_ : Universe -> Universe -> Prop.
Variable EqCongruence_chevy : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> chevy_ x1 x2 -> chevy_ y1 y2 .
Variable car_ : Universe -> Universe -> Prop.
Variable EqCongruence_car : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> car_ x1 x2 -> car_ y1 y2 .
Variable barrel_ : Universe -> Universe -> Prop.
Variable EqCongruence_barrel : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> barrel_ x1 x2 -> barrel_ y1 y2 .
Variable artifact_ : Universe -> Universe -> Prop.
Variable EqCongruence_artifact : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> artifact_ x1 x2 -> artifact_ y1 y2 .
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_agent : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> agent_ x1 x2 x3 -> agent_ y1 y2 y3 .
Variable actual_world_ : Universe -> Prop.
Variable EqCongruence_actual_world : forall x1 y1 : Universe, x1 = y1 -> actual_world_ x1 -> actual_world_ y1 .
Variable abstraction_ : Universe -> Universe -> Prop.
Variable EqCongruence_abstraction : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> abstraction_ x1 x2 -> abstraction_ y1 y2 .


Variable ax1_1 : (forall U V : Universe, (instrumentality_ U V -> artifact_ U V)).
Variable ax2_2 : (forall U V : Universe, (transport_ U V -> instrumentality_ U V)).
Variable ax3_3 : (forall U V : Universe, (vehicle_ U V -> transport_ U V)).
Variable ax4_4 : (forall U V : Universe, (car_ U V -> vehicle_ U V)).
Variable ax5_5 : (forall U V : Universe, (chevy_ U V -> car_ U V)).
Variable ax6_6 : (forall U V : Universe, (location_ U V -> object_ U V)).
Variable ax7_7 : (forall U V : Universe, (city_ U V -> location_ U V)).
Variable ax8_8 : (forall U V : Universe, (hollywood_placename_ U V -> placename_ U V)).
Variable ax9_9 : (forall U V : Universe, (abstraction_ U V -> unisex_ U V)).
Variable ax10_10 : (forall U V : Universe, (abstraction_ U V -> general_ U V)).
Variable ax11_11 : (forall U V : Universe, (abstraction_ U V -> nonhuman_ U V)).
Variable ax12_12 : (forall U V : Universe, (abstraction_ U V -> thing_ U V)).
Variable ax13_13 : (forall U V : Universe, (relation_ U V -> abstraction_ U V)).
Variable ax14_14 : (forall U V : Universe, (relname_ U V -> relation_ U V)).
Variable ax15_15 : (forall U V : Universe, (placename_ U V -> relname_ U V)).
Variable ax16_16 : (forall U V : Universe, (object_ U V -> unisex_ U V)).
Variable ax17_17 : (forall U V : Universe, (object_ U V -> impartial_ U V)).
Variable ax18_18 : (forall U V : Universe, (object_ U V -> nonliving_ U V)).
Variable ax19_19 : (forall U V : Universe, (entity_ U V -> existent_ U V)).
Variable ax20_20 : (forall U V : Universe, (entity_ U V -> specific_ U V)).
Variable ax21_21 : (forall U V : Universe, (entity_ U V -> thing_ U V)).
Variable ax22_22 : (forall U V : Universe, (object_ U V -> entity_ U V)).
Variable ax23_23 : (forall U V : Universe, (artifact_ U V -> object_ U V)).
Variable ax24_24 : (forall U V : Universe, (way_ U V -> artifact_ U V)).
Variable ax25_25 : (forall U V : Universe, (street_ U V -> way_ U V)).
Variable ax26_26 : (forall U V : Universe, (eventuality_ U V -> unisex_ U V)).
Variable ax27_27 : (forall U V : Universe, (eventuality_ U V -> nonexistent_ U V)).
Variable ax28_28 : (forall U V : Universe, (eventuality_ U V -> specific_ U V)).
Variable ax29_29 : (forall U V : Universe, (thing_ U V -> singleton_ U V)).
Variable ax30_30 : (forall U V : Universe, (eventuality_ U V -> thing_ U V)).
Variable ax31_31 : (forall U V : Universe, (event_ U V -> eventuality_ U V)).
Variable ax32_32 : (forall U V : Universe, (barrel_ U V -> event_ U V)).
Variable ax33_33 : (forall U V : Universe, (existent_ U V -> ~(nonexistent_ U V))).
Variable ax34_34 : (forall U V : Universe, (specific_ U V -> ~(general_ U V))).
Variable ax35_35 : (forall U V W : Universe, ((entity_ U V /\ (placename_ U W /\ of_ U W V)) -> ~((exists X : Universe, (placename_ U X /\ (X <> W /\ of_ U X V)))))).

Set Firstorder Depth 10.

Theorem co1_36 : ~((exists U : Universe, (actual_world_ U /\ (exists V W X Y : Universe, (of_ U V W /\ (city_ U W /\ (hollywood_placename_ U V /\ (placename_ U V /\ (street_ U W /\ (lonely_ U W /\ (chevy_ U X /\ (white_ U X /\ (dirty_ U X /\ (old_ U X /\ (event_ U Y /\ (agent_ U Y X /\ (present_ U Y /\ (barrel_ U Y /\ (down_ U Y W /\ in_ U Y W))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
