(*
% File     : NLP104+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : Every customer in a restaurant, problem 11
% Version  : [Bos00b] axioms.
% English  : Eliminating inconsistent interpretations in the statement
%            Every customer in a restaurant saw a person who drank a
%            coffee.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris081 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.00 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   35 (   0 unit)
%            Number of atoms       :   90 (   1 equality)
%            Maximal formula depth :   24 (   5 average)
%            Number of connectives :   60 (   5 ~  ;   0  |;  20  &)
%                                         (   0 <=>;  35 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   34 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   79 (   0 singleton;  74 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable unisex_ : Universe -> Universe -> Prop.
Variable EqCongruence_unisex : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> unisex_ x1 x2 -> unisex_ y1 y2 .
Variable thing_ : Universe -> Universe -> Prop.
Variable EqCongruence_thing : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> thing_ x1 x2 -> thing_ y1 y2 .
Variable substance_matter_ : Universe -> Universe -> Prop.
Variable EqCongruence_substance_matter : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> substance_matter_ x1 x2 -> substance_matter_ y1 y2 .
Variable specific_ : Universe -> Universe -> Prop.
Variable EqCongruence_specific : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> specific_ x1 x2 -> specific_ y1 y2 .
Variable singleton_ : Universe -> Universe -> Prop.
Variable EqCongruence_singleton : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> singleton_ x1 x2 -> singleton_ y1 y2 .
Variable see_ : Universe -> Universe -> Prop.
Variable EqCongruence_see : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> see_ x1 x2 -> see_ y1 y2 .
Variable restaurant_ : Universe -> Universe -> Prop.
Variable EqCongruence_restaurant : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> restaurant_ x1 x2 -> restaurant_ y1 y2 .
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_patient : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> patient_ x1 x2 x3 -> patient_ y1 y2 y3 .
Variable past_ : Universe -> Universe -> Prop.
Variable EqCongruence_past : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> past_ x1 x2 -> past_ y1 y2 .
Variable organism_ : Universe -> Universe -> Prop.
Variable EqCongruence_organism : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> organism_ x1 x2 -> organism_ y1 y2 .
Variable object_ : Universe -> Universe -> Prop.
Variable EqCongruence_object : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> object_ x1 x2 -> object_ y1 y2 .
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonreflexive : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonreflexive_ x1 x2 -> nonreflexive_ y1 y2 .
Variable nonliving_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonliving : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonliving_ x1 x2 -> nonliving_ y1 y2 .
Variable nonexistent_ : Universe -> Universe -> Prop.
Variable EqCongruence_nonexistent : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> nonexistent_ x1 x2 -> nonexistent_ y1 y2 .
Variable living_ : Universe -> Universe -> Prop.
Variable EqCongruence_living : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> living_ x1 x2 -> living_ y1 y2 .
Variable in_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_in : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> in_ x1 x2 x3 -> in_ y1 y2 y3 .
Variable impartial_ : Universe -> Universe -> Prop.
Variable EqCongruence_impartial : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> impartial_ x1 x2 -> impartial_ y1 y2 .
Variable human_person_ : Universe -> Universe -> Prop.
Variable EqCongruence_human_person : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> human_person_ x1 x2 -> human_person_ y1 y2 .
Variable human_ : Universe -> Universe -> Prop.
Variable EqCongruence_human : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> human_ x1 x2 -> human_ y1 y2 .
Variable food_ : Universe -> Universe -> Prop.
Variable EqCongruence_food : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> food_ x1 x2 -> food_ y1 y2 .
Variable existent_ : Universe -> Universe -> Prop.
Variable EqCongruence_existent : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> existent_ x1 x2 -> existent_ y1 y2 .
Variable eventuality_ : Universe -> Universe -> Prop.
Variable EqCongruence_eventuality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> eventuality_ x1 x2 -> eventuality_ y1 y2 .
Variable event_ : Universe -> Universe -> Prop.
Variable EqCongruence_event : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> event_ x1 x2 -> event_ y1 y2 .
Variable entity_ : Universe -> Universe -> Prop.
Variable EqCongruence_entity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> entity_ x1 x2 -> entity_ y1 y2 .
Variable drink_ : Universe -> Universe -> Prop.
Variable EqCongruence_drink : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> drink_ x1 x2 -> drink_ y1 y2 .
Variable customer_ : Universe -> Universe -> Prop.
Variable EqCongruence_customer : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> customer_ x1 x2 -> customer_ y1 y2 .
Variable coffee_ : Universe -> Universe -> Prop.
Variable EqCongruence_coffee : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> coffee_ x1 x2 -> coffee_ y1 y2 .
Variable building_ : Universe -> Universe -> Prop.
Variable EqCongruence_building : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> building_ x1 x2 -> building_ y1 y2 .
Variable beverage_ : Universe -> Universe -> Prop.
Variable EqCongruence_beverage : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> beverage_ x1 x2 -> beverage_ y1 y2 .
Variable artifact_ : Universe -> Universe -> Prop.
Variable EqCongruence_artifact : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> artifact_ x1 x2 -> artifact_ y1 y2 .
Variable animate_ : Universe -> Universe -> Prop.
Variable EqCongruence_animate : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> animate_ x1 x2 -> animate_ y1 y2 .
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_agent : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> agent_ x1 x2 x3 -> agent_ y1 y2 y3 .
Variable actual_world_ : Universe -> Prop.
Variable EqCongruence_actual_world : forall x1 y1 : Universe, x1 = y1 -> actual_world_ x1 -> actual_world_ y1 .


Variable ax1_1 : (forall U V : Universe, (artifact_ U V -> object_ U V)).
Variable ax2_2 : (forall U V : Universe, (building_ U V -> artifact_ U V)).
Variable ax3_3 : (forall U V : Universe, (restaurant_ U V -> building_ U V)).
Variable ax4_4 : (forall U V : Universe, (customer_ U V -> human_person_ U V)).
Variable ax5_5 : (forall U V : Universe, (human_person_ U V -> animate_ U V)).
Variable ax6_6 : (forall U V : Universe, (human_person_ U V -> human_ U V)).
Variable ax7_7 : (forall U V : Universe, (organism_ U V -> living_ U V)).
Variable ax8_8 : (forall U V : Universe, (organism_ U V -> impartial_ U V)).
Variable ax9_9 : (forall U V : Universe, (organism_ U V -> entity_ U V)).
Variable ax10_10 : (forall U V : Universe, (human_person_ U V -> organism_ U V)).
Variable ax11_11 : (forall U V : Universe, (object_ U V -> unisex_ U V)).
Variable ax12_12 : (forall U V : Universe, (object_ U V -> impartial_ U V)).
Variable ax13_13 : (forall U V : Universe, (object_ U V -> nonliving_ U V)).
Variable ax14_14 : (forall U V : Universe, (entity_ U V -> existent_ U V)).
Variable ax15_15 : (forall U V : Universe, (entity_ U V -> specific_ U V)).
Variable ax16_16 : (forall U V : Universe, (entity_ U V -> thing_ U V)).
Variable ax17_17 : (forall U V : Universe, (object_ U V -> entity_ U V)).
Variable ax18_18 : (forall U V : Universe, (substance_matter_ U V -> object_ U V)).
Variable ax19_19 : (forall U V : Universe, (food_ U V -> substance_matter_ U V)).
Variable ax20_20 : (forall U V : Universe, (beverage_ U V -> food_ U V)).
Variable ax21_21 : (forall U V : Universe, (coffee_ U V -> beverage_ U V)).
Variable ax22_22 : (forall U V : Universe, (drink_ U V -> event_ U V)).
Variable ax23_23 : (forall U V : Universe, (eventuality_ U V -> unisex_ U V)).
Variable ax24_24 : (forall U V : Universe, (eventuality_ U V -> nonexistent_ U V)).
Variable ax25_25 : (forall U V : Universe, (eventuality_ U V -> specific_ U V)).
Variable ax26_26 : (forall U V : Universe, (thing_ U V -> singleton_ U V)).
Variable ax27_27 : (forall U V : Universe, (eventuality_ U V -> thing_ U V)).
Variable ax28_28 : (forall U V : Universe, (event_ U V -> eventuality_ U V)).
Variable ax29_29 : (forall U V : Universe, (see_ U V -> event_ U V)).
Variable ax30_30 : (forall U V : Universe, (animate_ U V -> ~(nonliving_ U V))).
Variable ax31_31 : (forall U V : Universe, (existent_ U V -> ~(nonexistent_ U V))).
Variable ax32_32 : (forall U V : Universe, (nonliving_ U V -> ~(living_ U V))).
Variable ax33_33 : (forall U V W X : Universe, ((drink_ U V /\ (agent_ U V W /\ patient_ U V X)) -> beverage_ U X)).
Variable ax34_34 : (forall U V W X : Universe, ((nonreflexive_ U V /\ (agent_ U V W /\ patient_ U V X)) -> W <> X)).

Set Firstorder Depth 10.

Theorem co1_35 : ~((exists U : Universe, (actual_world_ U /\ (forall V W : Universe, ((customer_ U V /\ (restaurant_ U W /\ in_ U V W)) -> (exists X Y Z X1 : Universe, (coffee_ U X /\ (human_person_ U Y /\ (event_ U Z /\ (agent_ U Z Y /\ (patient_ U Z X /\ (past_ U Z /\ (nonreflexive_ U Z /\ (drink_ U Z /\ (event_ U X1 /\ (agent_ U X1 V /\ (patient_ U X1 Y /\ (past_ U X1 /\ (nonreflexive_ U X1 /\ see_ U X1))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
