(*
% File     : NLP095+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : Every customer in a restaurant, problem 2
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            Every customer in a restaurant saw a person who drank a
%            coffee.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris072 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.00 v2.7.0, 0.17 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   72 (   0 equality)
%            Maximal formula depth :   27 (  27 average)
%            Number of connectives :   73 (   2 ~  ;   0  |;  65  &)
%                                         (   0 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   28 (   0 singleton;   8 !;  20 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable see_ : Universe -> Universe -> Prop.
Variable restaurant_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable past_ : Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable in_ : Universe -> Universe -> Universe -> Prop.
Variable human_person_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable drink_ : Universe -> Universe -> Prop.
Variable customer_ : Universe -> Universe -> Prop.
Variable coffee_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Set Firstorder Depth 10.

Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V : Universe, (coffee_ U V /\ (forall W X : Universe, ((customer_ U W /\ (restaurant_ U X /\ in_ U W X)) -> (exists Y Z X1 : Universe, (human_person_ U Y /\ (event_ U Z /\ (agent_ U Z Y /\ (patient_ U Z V /\ (past_ U Z /\ (nonreflexive_ U Z /\ (drink_ U Z /\ (event_ U X1 /\ (agent_ U X1 W /\ (patient_ U X1 Y /\ (past_ U X1 /\ (nonreflexive_ U X1 /\ see_ U X1))))))))))))))))))) -> (exists X2 : Universe, (actual_world_ X2 /\ (forall X3 X4 : Universe, ((customer_ X2 X3 /\ (restaurant_ X2 X4 /\ in_ X2 X3 X4)) -> (exists X5 X6 X7 X8 : Universe, (coffee_ X2 X5 /\ (human_person_ X2 X6 /\ (event_ X2 X7 /\ (agent_ X2 X7 X6 /\ (patient_ X2 X7 X5 /\ (past_ X2 X7 /\ (nonreflexive_ X2 X7 /\ (drink_ X2 X7 /\ (event_ X2 X8 /\ (agent_ X2 X8 X3 /\ (patient_ X2 X8 X6 /\ (past_ X2 X8 /\ (nonreflexive_ X2 X8 /\ see_ X2 X8))))))))))))))))))) /\ ((exists X2 : Universe, (actual_world_ X2 /\ (forall X3 X4 : Universe, ((customer_ X2 X3 /\ (restaurant_ X2 X4 /\ in_ X2 X3 X4)) -> (exists X5 X6 X7 X8 : Universe, (coffee_ X2 X5 /\ (human_person_ X2 X6 /\ (event_ X2 X7 /\ (agent_ X2 X7 X6 /\ (patient_ X2 X7 X5 /\ (past_ X2 X7 /\ (nonreflexive_ X2 X7 /\ (drink_ X2 X7 /\ (event_ X2 X8 /\ (agent_ X2 X8 X3 /\ (patient_ X2 X8 X6 /\ (past_ X2 X8 /\ (nonreflexive_ X2 X8 /\ see_ X2 X8)))))))))))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V : Universe, (coffee_ U V /\ (forall W X : Universe, ((customer_ U W /\ (restaurant_ U X /\ in_ U W X)) -> (exists Y Z X1 : Universe, (human_person_ U Y /\ (event_ U Z /\ (agent_ U Z Y /\ (patient_ U Z V /\ (past_ U Z /\ (nonreflexive_ U Z /\ (drink_ U Z /\ (event_ U X1 /\ (agent_ U X1 W /\ (patient_ U X1 Y /\ (past_ U X1 /\ (nonreflexive_ U X1 /\ see_ U X1))))))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
