(*
% File     : NLP066+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : A man comes out of the bathroom, problem 8
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            A man comes out of the bathroom with a magnum in his hand.
%            The man fires six shots from his canon.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris043 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.00 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   68 (   0 equality)
%            Maximal formula depth :   20 (  20 average)
%            Number of connectives :   69 (   2 ~  ;   0  |;  57  &)
%                                         (   0 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   24 (   0 singleton;  12 !;  12 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable six_ : Universe -> Universe -> Prop.
Variable shot_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable man_ : Universe -> Universe -> Prop.
Variable male_ : Universe -> Universe -> Prop.
Variable group_ : Universe -> Universe -> Prop.
Variable from_loc_ : Universe -> Universe -> Universe -> Prop.
Variable fire_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable cannon_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Set Firstorder Depth 10.

Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V : Universe, ((forall W X : Universe, ((male_ U W /\ (man_ U W /\ (of_ U X W /\ (cannon_ U X /\ member_ U X V)))) -> (exists Y : Universe, (event_ U Y /\ (agent_ U Y W /\ (patient_ U Y X /\ (present_ U Y /\ (nonreflexive_ U Y /\ (fire_ U Y /\ from_loc_ U Y X))))))))) /\ (six_ U V /\ (group_ U V /\ (forall Z : Universe, (member_ U Z V -> shot_ U Z)))))))) -> (exists X1 : Universe, (actual_world_ X1 /\ (exists X2 : Universe, (male_ X1 X2 /\ ((forall X3 X4 : Universe, ((man_ X1 X3 /\ (of_ X1 X4 X2 /\ (cannon_ X1 X4 /\ member_ X1 X4 X2))) -> (exists X5 : Universe, (event_ X1 X5 /\ (agent_ X1 X5 X3 /\ (patient_ X1 X5 X4 /\ (present_ X1 X5 /\ (nonreflexive_ X1 X5 /\ (fire_ X1 X5 /\ from_loc_ X1 X5 X4))))))))) /\ (six_ X1 X2 /\ (group_ X1 X2 /\ (forall X6 : Universe, (member_ X1 X6 X2 -> shot_ X1 X6)))))))))) /\ ((exists X1 : Universe, (actual_world_ X1 /\ (exists X2 : Universe, (male_ X1 X2 /\ ((forall X3 X4 : Universe, ((man_ X1 X3 /\ (of_ X1 X4 X2 /\ (cannon_ X1 X4 /\ member_ X1 X4 X2))) -> (exists X5 : Universe, (event_ X1 X5 /\ (agent_ X1 X5 X3 /\ (patient_ X1 X5 X4 /\ (present_ X1 X5 /\ (nonreflexive_ X1 X5 /\ (fire_ X1 X5 /\ from_loc_ X1 X5 X4))))))))) /\ (six_ X1 X2 /\ (group_ X1 X2 /\ (forall X6 : Universe, (member_ X1 X6 X2 -> shot_ X1 X6))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V : Universe, ((forall W X : Universe, ((male_ U W /\ (man_ U W /\ (of_ U X W /\ (cannon_ U X /\ member_ U X V)))) -> (exists Y : Universe, (event_ U Y /\ (agent_ U Y W /\ (patient_ U Y X /\ (present_ U Y /\ (nonreflexive_ U Y /\ (fire_ U Y /\ from_loc_ U Y X))))))))) /\ (six_ U V /\ (group_ U V /\ (forall Z : Universe, (member_ U Z V -> shot_ U Z)))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
