(*
% File     : NLP059+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : A man comes out of the bathroom, problem 1
% Version  : [Bos00b] axioms.
% English  : Eliminating inconsistent interpretations in the statement
%            A man comes out of the bathroom with a magnum in his hand.
%            The man fires six shots from his canon.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris036 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.00 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   68 (   0 equality)
%            Maximal formula depth :   22 (  22 average)
%            Number of connectives :   69 (   2 ~  ;   0  |;  57  &)
%                                         (   0 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   28 (   0 singleton;  10 !;  18 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable six_ : Universe -> Universe -> Prop.
Variable shot_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable man_ : Universe -> Universe -> Prop.
Variable male_ : Universe -> Universe -> Prop.
Variable group_ : Universe -> Universe -> Prop.
Variable from_loc_ : Universe -> Universe -> Universe -> Prop.
Variable fire_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable cannon_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Set Firstorder Depth 10.

Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V W : Universe, (male_ U V /\ ((forall X : Universe, ((of_ U X V /\ (cannon_ U X /\ member_ U X W)) -> (exists Y Z : Universe, (man_ U Y /\ (event_ U Z /\ (agent_ U Z Y /\ (patient_ U Z X /\ (present_ U Z /\ (nonreflexive_ U Z /\ (fire_ U Z /\ from_loc_ U Z X)))))))))) /\ (six_ U W /\ (group_ U W /\ (forall X1 : Universe, (member_ U X1 W -> shot_ U X1))))))))) -> (exists X2 : Universe, (actual_world_ X2 /\ (exists X3 X4 : Universe, (male_ X2 X3 /\ ((forall X5 X6 : Universe, ((man_ X2 X5 /\ (of_ X2 X6 X3 /\ (cannon_ X2 X6 /\ member_ X2 X6 X4))) -> (exists X7 : Universe, (event_ X2 X7 /\ (agent_ X2 X7 X5 /\ (patient_ X2 X7 X6 /\ (present_ X2 X7 /\ (nonreflexive_ X2 X7 /\ (fire_ X2 X7 /\ from_loc_ X2 X7 X6))))))))) /\ (six_ X2 X4 /\ (group_ X2 X4 /\ (forall X8 : Universe, (member_ X2 X8 X4 -> shot_ X2 X8)))))))))) /\ ((exists X2 : Universe, (actual_world_ X2 /\ (exists X3 X4 : Universe, (male_ X2 X3 /\ ((forall X5 X6 : Universe, ((man_ X2 X5 /\ (of_ X2 X6 X3 /\ (cannon_ X2 X6 /\ member_ X2 X6 X4))) -> (exists X7 : Universe, (event_ X2 X7 /\ (agent_ X2 X7 X5 /\ (patient_ X2 X7 X6 /\ (present_ X2 X7 /\ (nonreflexive_ X2 X7 /\ (fire_ X2 X7 /\ from_loc_ X2 X7 X6))))))))) /\ (six_ X2 X4 /\ (group_ X2 X4 /\ (forall X8 : Universe, (member_ X2 X8 X4 -> shot_ X2 X8))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V W : Universe, (male_ U V /\ ((forall X : Universe, ((of_ U X V /\ (cannon_ U X /\ member_ U X W)) -> (exists Y Z : Universe, (man_ U Y /\ (event_ U Z /\ (agent_ U Z Y /\ (patient_ U Z X /\ (present_ U Z /\ (nonreflexive_ U Z /\ (fire_ U Z /\ from_loc_ U Z X)))))))))) /\ (six_ U W /\ (group_ U W /\ (forall X1 : Universe, (member_ U X1 W -> shot_ U X1))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
