(*
% File     : NLP011+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : The old dirty white Chevy problem 11
% Version  : [Bos00] axioms.
% English  : A problem generated by the DORIS [Bos00] system when parsing
%            the statement The old dirty white Chevy barrels down a lonely
%            street in Hollywood.
% Refs     : [Bos00] Bos (2000), DORIS: Discourse Oriented Representation an
%            [Bau99] Baumgartner (1999), FTP'2000 - Problem Sets
% Source   : [Bau99]
% Names    : 
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  124 (  12 equality)
%            Maximal formula depth :   43 (  43 average)
%            Number of connectives :  127 (   4 ~  ;   0  |; 121  &)
%                                         (   0 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   21 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   40 (   0 singleton;   0 !;  40 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable young_ : Universe -> Prop.
Variable EqCongruence_young : forall x1 y1 : Universe, x1 = y1 -> young_ x1 -> young_ y1 .
Variable white_ : Universe -> Prop.
Variable EqCongruence_white : forall x1 y1 : Universe, x1 = y1 -> white_ x1 -> white_ y1 .
Variable way_ : Universe -> Prop.
Variable EqCongruence_way : forall x1 y1 : Universe, x1 = y1 -> way_ x1 -> way_ y1 .
Variable street_ : Universe -> Prop.
Variable EqCongruence_street : forall x1 y1 : Universe, x1 = y1 -> street_ x1 -> street_ y1 .
Variable seat_ : Universe -> Prop.
Variable EqCongruence_seat : forall x1 y1 : Universe, x1 = y1 -> seat_ x1 -> seat_ y1 .
Variable old_ : Universe -> Prop.
Variable EqCongruence_old : forall x1 y1 : Universe, x1 = y1 -> old_ x1 -> old_ y1 .
Variable man_ : Universe -> Prop.
Variable EqCongruence_man : forall x1 y1 : Universe, x1 = y1 -> man_ x1 -> man_ y1 .
Variable lonely_ : Universe -> Prop.
Variable EqCongruence_lonely : forall x1 y1 : Universe, x1 = y1 -> lonely_ x1 -> lonely_ y1 .
Variable in_ : Universe -> Universe -> Prop.
Variable EqCongruence_in : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_ x1 x2 -> in_ y1 y2 .
Variable hollywood_ : Universe -> Prop.
Variable EqCongruence_hollywood : forall x1 y1 : Universe, x1 = y1 -> hollywood_ x1 -> hollywood_ y1 .
Variable furniture_ : Universe -> Prop.
Variable EqCongruence_furniture : forall x1 y1 : Universe, x1 = y1 -> furniture_ x1 -> furniture_ y1 .
Variable front_ : Universe -> Prop.
Variable EqCongruence_front : forall x1 y1 : Universe, x1 = y1 -> front_ x1 -> front_ y1 .
Variable fellow_ : Universe -> Prop.
Variable EqCongruence_fellow : forall x1 y1 : Universe, x1 = y1 -> fellow_ x1 -> fellow_ y1 .
Variable event_ : Universe -> Prop.
Variable EqCongruence_event : forall x1 y1 : Universe, x1 = y1 -> event_ x1 -> event_ y1 .
Variable down_ : Universe -> Universe -> Prop.
Variable EqCongruence_down : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> down_ x1 x2 -> down_ y1 y2 .
Variable dirty_ : Universe -> Prop.
Variable EqCongruence_dirty : forall x1 y1 : Universe, x1 = y1 -> dirty_ x1 -> dirty_ y1 .
Variable city_ : Universe -> Prop.
Variable EqCongruence_city : forall x1 y1 : Universe, x1 = y1 -> city_ x1 -> city_ y1 .
Variable chevy_ : Universe -> Prop.
Variable EqCongruence_chevy : forall x1 y1 : Universe, x1 = y1 -> chevy_ x1 -> chevy_ y1 .
Variable car_ : Universe -> Prop.
Variable EqCongruence_car : forall x1 y1 : Universe, x1 = y1 -> car_ x1 -> car_ y1 .
Variable barrel_ : Universe -> Universe -> Prop.
Variable EqCongruence_barrel : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> barrel_ x1 x2 -> barrel_ y1 y2 .



Set Firstorder Depth 10.

Theorem co1_1 : (((exists U V W X Y Z X1 X2 X3 X4 : Universe, (seat_ U /\ (furniture_ U /\ (front_ U /\ (hollywood_ V /\ (city_ V /\ (event_ W /\ (street_ X /\ (way_ X /\ (lonely_ X /\ (chevy_ Y /\ (car_ Y /\ (white_ Y /\ (dirty_ Y /\ (old_ Y /\ (barrel_ W Y /\ (down_ W X /\ (in_ W V /\ (seat_ X2 /\ (furniture_ X2 /\ (front_ X2 /\ (Z <> X1 /\ (fellow_ Z /\ (man_ Z /\ (young_ Z /\ (fellow_ X1 /\ (man_ X1 /\ (young_ X1 /\ (Z = X3 /\ (in_ X3 X2 /\ (X1 = X4 /\ in_ X4 U))))))))))))))))))))))))))))))) -> (exists X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 : Universe, (seat_ X5 /\ (furniture_ X5 /\ (front_ X5 /\ (hollywood_ X6 /\ (city_ X6 /\ (event_ X7 /\ (street_ X8 /\ (way_ X8 /\ (lonely_ X8 /\ (chevy_ X9 /\ (car_ X9 /\ (white_ X9 /\ (dirty_ X9 /\ (old_ X9 /\ (barrel_ X7 X9 /\ (down_ X7 X8 /\ (in_ X7 X6 /\ (seat_ X12 /\ (furniture_ X12 /\ (front_ X12 /\ (X10 <> X11 /\ (fellow_ X10 /\ (man_ X10 /\ (young_ X10 /\ (fellow_ X11 /\ (man_ X11 /\ (young_ X11 /\ (X10 = X13 /\ (in_ X13 X5 /\ (X11 = X14 /\ in_ X14 X12)))))))))))))))))))))))))))))))) /\ ((exists X15 X16 X17 X18 X19 X20 X21 X22 X23 X24 : Universe, (seat_ X15 /\ (furniture_ X15 /\ (front_ X15 /\ (hollywood_ X16 /\ (city_ X16 /\ (event_ X17 /\ (street_ X18 /\ (way_ X18 /\ (lonely_ X18 /\ (chevy_ X19 /\ (car_ X19 /\ (white_ X19 /\ (dirty_ X19 /\ (old_ X19 /\ (barrel_ X17 X19 /\ (down_ X17 X18 /\ (in_ X17 X16 /\ (seat_ X22 /\ (furniture_ X22 /\ (front_ X22 /\ (X20 <> X21 /\ (fellow_ X20 /\ (man_ X20 /\ (young_ X20 /\ (fellow_ X21 /\ (man_ X21 /\ (young_ X21 /\ (X20 = X23 /\ (in_ X23 X15 /\ (X21 = X24 /\ in_ X24 X22))))))))))))))))))))))))))))))) -> (exists X25 X26 X27 X28 X29 X30 X31 X32 X33 X34 : Universe, (seat_ X25 /\ (furniture_ X25 /\ (front_ X25 /\ (hollywood_ X26 /\ (city_ X26 /\ (event_ X27 /\ (street_ X28 /\ (way_ X28 /\ (lonely_ X28 /\ (chevy_ X29 /\ (car_ X29 /\ (white_ X29 /\ (dirty_ X29 /\ (old_ X29 /\ (barrel_ X27 X29 /\ (down_ X27 X28 /\ (in_ X27 X26 /\ (seat_ X32 /\ (furniture_ X32 /\ (front_ X32 /\ (X30 <> X31 /\ (fellow_ X30 /\ (man_ X30 /\ (young_ X30 /\ (fellow_ X31 /\ (man_ X31 /\ (young_ X31 /\ (X30 = X33 /\ (in_ X33 X32 /\ (X31 = X34 /\ in_ X34 X25))))))))))))))))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
