(*
% File     : NLP009+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : The old dirty white Chevy problem 9
% Version  : [Bos00] axioms.
% English  : A problem generated by the DORIS [Bos00] system when parsing
%            the statement The old dirty white Chevy barrels down a lonely
%            street in Hollywood.
% Refs     : [Bos00] Bos (2000), DORIS: Discourse Oriented Representation an
%            [Bau99] Baumgartner (1999), FTP'2000 - Problem Sets
% Source   : [Bau99]
% Names    : 
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  112 (  12 equality)
%            Maximal formula depth :   39 (  39 average)
%            Number of connectives :  115 (   4 ~  ;   0  |; 109  &)
%                                         (   0 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   21 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   36 (   0 singleton;   0 !;  36 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable young_ : Universe -> Prop.
Variable EqCongruence_young : forall x1 y1 : Universe, x1 = y1 -> young_ x1 -> young_ y1 .
Variable white_ : Universe -> Prop.
Variable EqCongruence_white : forall x1 y1 : Universe, x1 = y1 -> white_ x1 -> white_ y1 .
Variable way_ : Universe -> Prop.
Variable EqCongruence_way : forall x1 y1 : Universe, x1 = y1 -> way_ x1 -> way_ y1 .
Variable street_ : Universe -> Prop.
Variable EqCongruence_street : forall x1 y1 : Universe, x1 = y1 -> street_ x1 -> street_ y1 .
Variable seat_ : Universe -> Prop.
Variable EqCongruence_seat : forall x1 y1 : Universe, x1 = y1 -> seat_ x1 -> seat_ y1 .
Variable old_ : Universe -> Prop.
Variable EqCongruence_old : forall x1 y1 : Universe, x1 = y1 -> old_ x1 -> old_ y1 .
Variable man_ : Universe -> Prop.
Variable EqCongruence_man : forall x1 y1 : Universe, x1 = y1 -> man_ x1 -> man_ y1 .
Variable lonely_ : Universe -> Prop.
Variable EqCongruence_lonely : forall x1 y1 : Universe, x1 = y1 -> lonely_ x1 -> lonely_ y1 .
Variable in_ : Universe -> Universe -> Prop.
Variable EqCongruence_in : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> in_ x1 x2 -> in_ y1 y2 .
Variable hollywood_ : Universe -> Prop.
Variable EqCongruence_hollywood : forall x1 y1 : Universe, x1 = y1 -> hollywood_ x1 -> hollywood_ y1 .
Variable furniture_ : Universe -> Prop.
Variable EqCongruence_furniture : forall x1 y1 : Universe, x1 = y1 -> furniture_ x1 -> furniture_ y1 .
Variable front_ : Universe -> Prop.
Variable EqCongruence_front : forall x1 y1 : Universe, x1 = y1 -> front_ x1 -> front_ y1 .
Variable fellow_ : Universe -> Prop.
Variable EqCongruence_fellow : forall x1 y1 : Universe, x1 = y1 -> fellow_ x1 -> fellow_ y1 .
Variable event_ : Universe -> Prop.
Variable EqCongruence_event : forall x1 y1 : Universe, x1 = y1 -> event_ x1 -> event_ y1 .
Variable down_ : Universe -> Universe -> Prop.
Variable EqCongruence_down : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> down_ x1 x2 -> down_ y1 y2 .
Variable dirty_ : Universe -> Prop.
Variable EqCongruence_dirty : forall x1 y1 : Universe, x1 = y1 -> dirty_ x1 -> dirty_ y1 .
Variable city_ : Universe -> Prop.
Variable EqCongruence_city : forall x1 y1 : Universe, x1 = y1 -> city_ x1 -> city_ y1 .
Variable chevy_ : Universe -> Prop.
Variable EqCongruence_chevy : forall x1 y1 : Universe, x1 = y1 -> chevy_ x1 -> chevy_ y1 .
Variable car_ : Universe -> Prop.
Variable EqCongruence_car : forall x1 y1 : Universe, x1 = y1 -> car_ x1 -> car_ y1 .
Variable barrel_ : Universe -> Universe -> Prop.
Variable EqCongruence_barrel : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> barrel_ x1 x2 -> barrel_ y1 y2 .



Set Firstorder Depth 10.

Theorem co1_1 : (((exists U V W X Y Z X1 X2 X3 : Universe, (hollywood_ U /\ (city_ U /\ (event_ V /\ (street_ W /\ (way_ W /\ (lonely_ W /\ (chevy_ X /\ (car_ X /\ (white_ X /\ (dirty_ X /\ (old_ X /\ (barrel_ V X /\ (down_ V W /\ (in_ V U /\ (seat_ X1 /\ (furniture_ X1 /\ (front_ X1 /\ (Y <> Z /\ (fellow_ Y /\ (man_ Y /\ (young_ Y /\ (fellow_ Z /\ (man_ Z /\ (young_ Z /\ (Y = X2 /\ (in_ X2 X1 /\ (Z = X3 /\ in_ X3 X1)))))))))))))))))))))))))))) -> (exists X4 X5 X6 X7 X8 X9 X10 X11 X12 : Universe, (hollywood_ X4 /\ (city_ X4 /\ (event_ X5 /\ (chevy_ X6 /\ (car_ X6 /\ (white_ X6 /\ (dirty_ X6 /\ (old_ X6 /\ (street_ X7 /\ (way_ X7 /\ (lonely_ X7 /\ (barrel_ X5 X6 /\ (down_ X5 X7 /\ (in_ X5 X4 /\ (seat_ X10 /\ (furniture_ X10 /\ (front_ X10 /\ (X8 <> X9 /\ (fellow_ X8 /\ (man_ X8 /\ (young_ X8 /\ (fellow_ X9 /\ (man_ X9 /\ (young_ X9 /\ (X8 = X11 /\ (in_ X11 X10 /\ (X9 = X12 /\ in_ X12 X10))))))))))))))))))))))))))))) /\ ((exists X13 X14 X15 X16 X17 X18 X19 X20 X21 : Universe, (hollywood_ X13 /\ (city_ X13 /\ (event_ X14 /\ (chevy_ X15 /\ (car_ X15 /\ (white_ X15 /\ (dirty_ X15 /\ (old_ X15 /\ (street_ X16 /\ (way_ X16 /\ (lonely_ X16 /\ (barrel_ X14 X15 /\ (down_ X14 X16 /\ (in_ X14 X13 /\ (seat_ X19 /\ (furniture_ X19 /\ (front_ X19 /\ (X17 <> X18 /\ (fellow_ X17 /\ (man_ X17 /\ (young_ X17 /\ (fellow_ X18 /\ (man_ X18 /\ (young_ X18 /\ (X17 = X20 /\ (in_ X20 X19 /\ (X18 = X21 /\ in_ X21 X19)))))))))))))))))))))))))))) -> (exists X22 X23 X24 X25 X26 X27 X28 X29 X30 : Universe, (hollywood_ X22 /\ (city_ X22 /\ (event_ X23 /\ (street_ X24 /\ (way_ X24 /\ (lonely_ X24 /\ (chevy_ X25 /\ (car_ X25 /\ (white_ X25 /\ (dirty_ X25 /\ (old_ X25 /\ (barrel_ X23 X25 /\ (down_ X23 X24 /\ (in_ X23 X22 /\ (seat_ X28 /\ (furniture_ X28 /\ (front_ X28 /\ (X26 <> X27 /\ (fellow_ X26 /\ (man_ X26 /\ (young_ X26 /\ (fellow_ X27 /\ (man_ X27 /\ (young_ X27 /\ (X26 = X29 /\ (in_ X29 X28 /\ (X27 = X30 /\ in_ X30 X28)))))))))))))))))))))))))))))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
