(*
% File     : MSC009+1 : ILTP v1.1.2
% Domain   : Miscellaneous
% Problem  : Definitions of a family structure
% Version  : Especial.
% English  : 
% Refs     : [FL+93] Fermuller et al. (1993), Resolution Methods for the De
% Source   : [FL+93]
% Names    : 
% Status   : Satisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved (Problem negated)
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    7 (   0 unit)
%            Number of atoms       :   26 (   0 equality)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   21 (   2 ~  ;   1  |;  10  &)
%                                         (   7 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   13 (   0 singleton;   8 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable sex_ : Universe -> Universe -> Prop.
Variable person_ : Universe -> Prop.
Variable parent_with_sons_only_ : Universe -> Prop.
Variable parent_ : Universe -> Prop.
Variable mother_ : Universe -> Prop.
Variable male_ : Universe -> Prop.
Variable grandparent_ : Universe -> Prop.
Variable female_ : Universe -> Prop.
Variable father_ : Universe -> Prop.
Variable child_ : Universe -> Universe -> Prop.


Variable female_1 : (forall X : Universe, (female_ X <-> ~(male_ X))).
Variable person_2 : (forall X : Universe, (person_ X <-> (exists Y : Universe, (sex_ X Y /\ (male_ Y \/ female_ Y))))).
Variable parent_3 : (forall X : Universe, (parent_ X <-> (person_ X /\ (exists Y : Universe, (child_ X Y /\ person_ Y))))).
Variable mother_4 : (forall X : Universe, (mother_ X <-> (parent_ X /\ (exists Y : Universe, (sex_ X Y /\ female_ Y))))).
Variable father_5 : (forall X : Universe, (father_ X <-> (parent_ X /\ ~(mother_ X)))).
Variable grandparent_6 : (forall X : Universe, (grandparent_ X <-> (parent_ X /\ (exists Y : Universe, (child_ X Y /\ parent_ Y))))).
Variable parent_with_sons_only_7 : (forall X : Universe, (parent_with_sons_only_ X <-> (parent_ X /\ (forall Y : Universe, (child_ X Y -> (exists Z : Universe, (sex_ Y Z /\ male_ Z))))))).

Theorem conjecture_8 : False.
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
