(*
% File     : MGT065+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Long-run hazard of mortality
% Version  : [Han98] axioms.
% English  : The long-run hazard of mortality for an endowed organization with
%            either a fragile or a robust position in a drifting environment
%            exceeds the hazard near founding.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 11 [Han98]
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.44 v2.7.0, 0.33 v2.6.0, 0.50 v2.5.0, 0.33 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   17 (   5 unit)
%            Number of atoms       :   70 (  12 equality)
%            Maximal formula depth :   18 (   5 average)
%            Number of connectives :   61 (   8 ~  ;   5  |;  28  &)
%                                         (   7 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-3 arity)
%            Number of functors    :   11 (   9 constant; 0-2 arity)
%            Number of variables   :   29 (   0 singleton;  29 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable robust_position_ : Universe -> Prop.
Variable EqCongruence_robust_position : forall x1 y1 : Universe, x1 = y1 -> robust_position_ x1 -> robust_position_ y1 .
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable EqCongruence_positional_advantage : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> positional_advantage_ x1 x2 -> positional_advantage_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable EqCongruence_is_aligned : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> is_aligned_ x1 x2 -> is_aligned_ y1 y2 .
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable EqCongruence_has_immunity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> has_immunity_ x1 x2 -> has_immunity_ y1 y2 .
Variable has_endowment_ : Universe -> Prop.
Variable EqCongruence_has_endowment : forall x1 y1 : Universe, x1 = y1 -> has_endowment_ x1 -> has_endowment_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable fragile_position_ : Universe -> Prop.
Variable EqCongruence_fragile_position : forall x1 y1 : Universe, x1 = y1 -> fragile_position_ x1 -> fragile_position_ y1 .
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_dissimilar : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> dissimilar_ x1 x2 x3 -> dissimilar_ y1 y2 y3 .

Variable zero_ : Universe.
Variable very_low_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable mod2_ : Universe.
Variable mod1_ : Universe.
Variable low_ : Universe.
Variable high_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable EqCongruence_hazard_of_mortality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hazard_of_mortality_ x1 x2 = hazard_of_mortality_ y1 y2 .
Variable eta_ : Universe.
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable definition_2_8 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_9 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_15_10 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable assumption_17_11 : (forall X T : Universe, (organization_ X -> ((has_immunity_ X T -> (hazard_of_mortality_ X T) = very_low_) /\ (~(has_immunity_ X T) -> (((is_aligned_ X T /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = low_) /\ (((~(is_aligned_ X T) /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = mod1_) /\ (((is_aligned_ X T /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = mod2_) /\ ((~(is_aligned_ X T) /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = high_)))))))).
Variable assumption_18a_12 : greater_ high_ mod1_.
Variable assumption_18b_13 : greater_ mod1_ low_.
Variable assumption_18c_14 : greater_ low_ very_low_.
Variable assumption_18d_15 : greater_ high_ mod2_.
Variable assumption_18e_16 : greater_ mod2_ low_.

Set Firstorder Depth 10.

Theorem theorem_11_17 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ ((robust_position_ X \/ fragile_position_ X) /\ (has_endowment_ X /\ ((age_ X T0) = zero_ /\ (greater_ sigma_ zero_ /\ (greater_ tau_ zero_ /\ (greater_ eta_ zero_ /\ (smaller_or_equal_ (age_ X T1) sigma_ /\ (smaller_or_equal_ (age_ X T1) tau_ /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) sigma_ /\ (greater_ (age_ X T2) tau_ /\ greater_ (age_ X T2) eta_)))))))))))) -> (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
