(*
% File     : MGT062+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Condictions for decreasing hazard of mortality
% Version  : [Han98] axioms.
% English  : If environmental drift destroys alignment exactly when advantage 
%            can be gained from occupancy of a robust position, then the 
%            hazard of mortality for an unendowed organization with a robust 
%            position decreases with age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 8 [Han98]
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.56 v2.7.0, 0.33 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   1 unit)
%            Number of atoms       :   63 (  13 equality)
%            Maximal formula depth :   14 (   6 average)
%            Number of connectives :   60 (  11 ~  ;   4  |;  24  &)
%                                         (   7 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-3 arity)
%            Number of functors    :   10 (   8 constant; 0-2 arity)
%            Number of variables   :   31 (   0 singleton;  31 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable robust_position_ : Universe -> Prop.
Variable EqCongruence_robust_position : forall x1 y1 : Universe, x1 = y1 -> robust_position_ x1 -> robust_position_ y1 .
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable EqCongruence_positional_advantage : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> positional_advantage_ x1 x2 -> positional_advantage_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable EqCongruence_is_aligned : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> is_aligned_ x1 x2 -> is_aligned_ y1 y2 .
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable EqCongruence_has_immunity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> has_immunity_ x1 x2 -> has_immunity_ y1 y2 .
Variable has_endowment_ : Universe -> Prop.
Variable EqCongruence_has_endowment : forall x1 y1 : Universe, x1 = y1 -> has_endowment_ x1 -> has_endowment_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.
Variable EqCongruence_dissimilar : forall x1 x2 x3 y1 y2 y3 : Universe, x1 = y1 -> x2 = y2 -> x3 = y3 -> dissimilar_ x1 x2 x3 -> dissimilar_ y1 y2 y3 .

Variable zero_ : Universe.
Variable very_low_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable mod2_ : Universe.
Variable mod1_ : Universe.
Variable low_ : Universe.
Variable high_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable EqCongruence_hazard_of_mortality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hazard_of_mortality_ x1 x2 = hazard_of_mortality_ y1 y2 .
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_1_7 : (forall X T : Universe, ((organization_ X /\ ~(has_endowment_ X)) -> ~(has_immunity_ X T))).
Variable definition_2_8 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_9 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_15_10 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable definition_4_11 : (forall X : Universe, (robust_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) tau_ -> ~(positional_advantage_ X T)) /\ (greater_ (age_ X T) tau_ -> positional_advantage_ X T))))).
Variable assumption_17_12 : (forall X T : Universe, (organization_ X -> ((has_immunity_ X T -> (hazard_of_mortality_ X T) = very_low_) /\ (~(has_immunity_ X T) -> (((is_aligned_ X T /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = low_) /\ (((~(is_aligned_ X T) /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = mod1_) /\ (((is_aligned_ X T /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = mod2_) /\ ((~(is_aligned_ X T) /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = high_)))))))).
Variable assumption_19_13 : greater_ mod2_ mod1_.

Set Firstorder Depth 10.

Theorem theorem_8_14 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ (robust_position_ X /\ (~(has_endowment_ X) /\ ((age_ X T0) = zero_ /\ (greater_ sigma_ zero_ /\ (greater_ tau_ zero_ /\ (sigma_ = tau_ /\ (smaller_or_equal_ (age_ X T1) sigma_ /\ greater_ (age_ X T2) sigma_)))))))) -> (smaller_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
