(*
% File     : MGT060+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Hazard of mortality is lower during periods of immunity
% Version  : [Han98] axioms.
% English  : An organization's hazard of mortality is lower during periods in
%            which it has immunity than in periods in which it does not.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : ASSUMPTION 3 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.33 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   13 (   5 unit)
%            Number of atoms       :   41 (   8 equality)
%            Maximal formula depth :   12 (   4 average)
%            Number of connectives :   35 (   7 ~  ;   4  |;  12  &)
%                                         (   3 <=>;   9 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-2 arity)
%            Number of functors    :    6 (   5 constant; 0-2 arity)
%            Number of variables   :   18 (   0 singleton;  18 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable EqCongruence_positional_advantage : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> positional_advantage_ x1 x2 -> positional_advantage_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable EqCongruence_is_aligned : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> is_aligned_ x1 x2 -> is_aligned_ y1 y2 .
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable EqCongruence_has_immunity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> has_immunity_ x1 x2 -> has_immunity_ y1 y2 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .

Variable very_low_ : Universe.
Variable mod2_ : Universe.
Variable mod1_ : Universe.
Variable low_ : Universe.
Variable high_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable EqCongruence_hazard_of_mortality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hazard_of_mortality_ x1 x2 = hazard_of_mortality_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_17_7 : (forall X T : Universe, (organization_ X -> ((has_immunity_ X T -> (hazard_of_mortality_ X T) = very_low_) /\ (~(has_immunity_ X T) -> (((is_aligned_ X T /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = low_) /\ (((~(is_aligned_ X T) /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = mod1_) /\ (((is_aligned_ X T /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = mod2_) /\ ((~(is_aligned_ X T) /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = high_)))))))).
Variable assumption_18a_8 : greater_ high_ mod1_.
Variable assumption_18b_9 : greater_ mod1_ low_.
Variable assumption_18c_10 : greater_ low_ very_low_.
Variable assumption_18d_11 : greater_ high_ mod2_.
Variable assumption_18e_12 : greater_ mod2_ low_.

Set Firstorder Depth 10.

Theorem assumption_3_13 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
