(*
% File     : MGT058+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : An organization's position cannot be both fragile and robust
% Version  : [Han98] axioms.
% English  : 
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 10 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.22 v2.7.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   32 (   4 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :   27 (   4 ~  ;   4  |;   8  &)
%                                         (   5 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   3 constant; 0-2 arity)
%            Number of variables   :   19 (   0 singleton;  18 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable robust_position_ : Universe -> Prop.
Variable EqCongruence_robust_position : forall x1 y1 : Universe, x1 = y1 -> robust_position_ x1 -> robust_position_ y1 .
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable EqCongruence_positional_advantage : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> positional_advantage_ x1 x2 -> positional_advantage_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .
Variable fragile_position_ : Universe -> Prop.
Variable EqCongruence_fragile_position : forall x1 y1 : Universe, x1 = y1 -> fragile_position_ x1 -> fragile_position_ y1 .

Variable zero_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_3_7 : (forall X : Universe, (fragile_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) sigma_ -> positional_advantage_ X T) /\ (greater_ (age_ X T) sigma_ -> ~(positional_advantage_ X T)))))).
Variable definition_4_8 : (forall X : Universe, (robust_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) tau_ -> ~(positional_advantage_ X T)) /\ (greater_ (age_ X T) tau_ -> positional_advantage_ X T))))).

Set Firstorder Depth 10.

Theorem lemma_10_9 : (forall X : Universe, ((organization_ X /\ ((exists T0 : Universe, (age_ X T0) = zero_) /\ (greater_or_equal_ sigma_ zero_ /\ greater_or_equal_ tau_ zero_))) -> ~((fragile_position_ X /\ robust_position_ X)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
