(*
% File     : MGT057+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for a constant then increasing hazard of mortality
% Version  : [Han98] axioms.
% English  : In a drifting environment, an endowed organization's hazard of 
%            mortality is constant during the period of immunity; beyond the 
%            period of immunity, the hazard rises with age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 6 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.33 v2.5.0, 0.00 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   10 (   0 unit)
%            Number of atoms       :   38 (   6 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   31 (   3 ~  ;   4  |;  14  &)
%                                         (   4 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   2 constant; 0-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable EqTransitivity : forall x y z : Universe, x = y -> y = z -> x = z.
Variable EqSymmetry : forall x y : Universe, x = y -> y = x.
Variable EqReflexivity : forall x : Universe, x = x.
Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_or_equal_ x1 x2 -> smaller_or_equal_ y1 y2 .
Variable smaller_ : Universe -> Universe -> Prop.
Variable EqCongruence_smaller : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> smaller_ x1 x2 -> smaller_ y1 y2 .
Variable organization_ : Universe -> Prop.
Variable EqCongruence_organization : forall x1 y1 : Universe, x1 = y1 -> organization_ x1 -> organization_ y1 .
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable EqCongruence_has_immunity : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> has_immunity_ x1 x2 -> has_immunity_ y1 y2 .
Variable has_endowment_ : Universe -> Prop.
Variable EqCongruence_has_endowment : forall x1 y1 : Universe, x1 = y1 -> has_endowment_ x1 -> has_endowment_ y1 .
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater_or_equal : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_or_equal_ x1 x2 -> greater_or_equal_ y1 y2 .
Variable greater_ : Universe -> Universe -> Prop.
Variable EqCongruence_greater : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> greater_ x1 x2 -> greater_ y1 y2 .

Variable zero_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable EqCongruence_hazard_of_mortality : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> hazard_of_mortality_ x1 x2 = hazard_of_mortality_ y1 y2 .
Variable eta_ : Universe.
Variable age_ : Universe -> Universe -> Universe.
Variable EqCongruence_age : forall x1 x2 y1 y2 : Universe, x1 = y1 -> x2 = y2 -> age_ x1 x2 = age_ y1 y2 .

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable assumption_2_8 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ has_immunity_ X T)) -> (hazard_of_mortality_ X T0) = (hazard_of_mortality_ X T))).
Variable assumption_3_9 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).

Set Firstorder Depth 10.

Theorem theorem_6_10 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ (has_endowment_ X /\ ((age_ X T0) = zero_ /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) eta_ /\ greater_ eta_ zero_))))) -> (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0)))).
Proof.
  time solve [ firstorder ].
Qed.

End FOFProblem.
